/*
 * Decompiled with CFR 0.152.
 */
package org.josast.ApplicationKissTool;

import java.math.BigInteger;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.concurrent.BlockingQueue;
import java.util.logging.Logger;
import javafx.application.Platform;
import javafx.concurrent.Task;
import org.josast.ApplicationKissTool.Ax25Display;
import org.josast.ApplicationKissTool.Configuration;
import org.josast.ApplicationKissTool.Controler;
import org.josast.ApplicationKissTool.ManageDataFile;
import org.josast.ApplicationKissTool.ReceivedData;
import org.josast.ApplicationKissTool.TlmData;
import org.josast.telemetry.api.TelemetryAnalysisInterface;
import org.josast.telemetry.api.TelemetryAnalysisProvider;
import org.josast.telemetry.api.TelemetryDataInterface;

public class TaskManageReceivedData
extends Task<String> {
    private static Logger appLogger = Logger.getLogger("AmsatLogger");
    private final SimpleDateFormat ISO8601DATEFORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
    private final Configuration conf = Configuration.getInstance();
    private Ax25Display ax25display = new Ax25Display();
    private ManageDataFile mdf = new ManageDataFile();
    TelemetryAnalysisProvider tap = new TelemetryAnalysisProvider();
    private BlockingQueue<ReceivedData> blockingQueue = null;
    Controler ctrl = null;

    public TaskManageReceivedData(BlockingQueue<ReceivedData> blockingQueueIn, Controler ctrlIn) {
        this.blockingQueue = blockingQueueIn;
        this.ctrl = ctrlIn;
    }

    private void displayLog(final String string) {
        Platform.runLater(new Runnable(){

            @Override
            public void run() {
                try {
                    TaskManageReceivedData.this.ctrl.displayLog(string);
                }
                catch (Exception e) {
                    TaskManageReceivedData.this.displayLog("Run - error");
                    TaskManageReceivedData.this.displayLog(e.toString());
                    e.printStackTrace();
                }
            }
        });
    }

    private void displayData(final ReceivedData decodedData) {
        Platform.runLater(new Runnable(){

            @Override
            public void run() {
                String rcvCallsign = TaskManageReceivedData.this.ax25display.getCallsignFrom();
                try {
                    int noradframe;
                    if (!TaskManageReceivedData.this.conf.isSilentMode()) {
                        String satname = TaskManageReceivedData.this.ctrl.getName(rcvCallsign);
                        if (satname == null) {
                            TaskManageReceivedData.this.ctrl.displayLog(decodedData.toString());
                            TaskManageReceivedData.this.ctrl.SetDecodedData(TaskManageReceivedData.this.ax25display.getDisplay());
                        } else {
                            appLogger.severe("satname " + satname);
                            TelemetryAnalysisInterface dataAnalyser = TaskManageReceivedData.this.tap.getDataAnalyser(satname);
                            TelemetryDataInterface td = dataAnalyser.analyse(decodedData.getData());
                            TaskManageReceivedData.this.ctrl.setDecodedTable(td.getDataList(), td.getTelemetryName());
                        }
                    }
                    if ((noradframe = TaskManageReceivedData.this.ctrl.getNorad(rcvCallsign)) == 0) {
                        noradframe = TaskManageReceivedData.this.conf.getNorad();
                    }
                    TaskManageReceivedData.this.ctrl.SendSids(decodedData, noradframe);
                    TaskManageReceivedData.this.ctrl.IncrementNbFrameTraited();
                }
                catch (Exception e) {
                    TaskManageReceivedData.this.displayLog("Run - error");
                    TaskManageReceivedData.this.displayLog(e.toString());
                    e.printStackTrace();
                }
            }
        });
    }

    @Override
    protected String call() throws Exception {
        this.displayLog("Message Treatment Lanched");
        this.tap.displayProviderNames();
        this.displayLog("Waiting Data !!!");
        while (true) {
            ReceivedData decodedData;
            int valid;
            if ((valid = this.ax25display.setdata(decodedData = this.blockingQueue.take())) == 0) {
                String calsignr = this.ax25display.getCallsignFrom();
                if (calsignr == null) {
                    this.displayLog(" calsign not decoded");
                }
                Date lastFrameTime = new Date();
                String creationdate = this.ISO8601DATEFORMAT.format(lastFrameTime);
                String hexaString = new BigInteger(1, decodedData.getData()).toString(16);
                TlmData tlmData = new TlmData(hexaString, this.ax25display.getCallsignFrom(), this.conf.getLongitude(), this.conf.getLatitude(), creationdate);
                this.mdf.setRepositoryPath(this.conf.getOutputFileDirectory());
                if (this.conf.isRawFileBoolean()) {
                    this.mdf.saveRawFile(decodedData.getData());
                }
                if (this.conf.isJsonFileBoolean() && this.mdf.saveTlmData(tlmData) != 0) {
                    this.displayLog("Error creation JSON file");
                }
                this.displayData(decodedData);
                continue;
            }
            this.displayLog(" Frame  not decoded");
        }
    }
}

