/*
 * Decompiled with CFR 0.152.
 */
package org.castor.xml;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import javax.inject.Inject;
import javax.xml.parsers.SAXParser;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.castor.core.util.AbstractProperties;
import org.castor.core.util.Messages;
import org.castor.mapping.BindingType;
import org.castor.mapping.MappingUnmarshaller;
import org.castor.xml.InternalContext;
import org.castor.xml.JavaNaming;
import org.castor.xml.JavaNamingImpl;
import org.castor.xml.XMLNaming;
import org.castor.xml.XMLProperties;
import org.exolab.castor.mapping.Mapping;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.mapping.MappingLoader;
import org.exolab.castor.util.RegExpEvaluator;
import org.exolab.castor.xml.Introspector;
import org.exolab.castor.xml.NodeType;
import org.exolab.castor.xml.OutputFormat;
import org.exolab.castor.xml.ResolverException;
import org.exolab.castor.xml.Serializer;
import org.exolab.castor.xml.XMLClassDescriptorResolver;
import org.exolab.castor.xml.XMLSerializerFactory;
import org.exolab.castor.xml.util.DefaultNaming;
import org.exolab.castor.xml.util.ResolverStrategy;
import org.exolab.castor.xml.util.XMLParserUtils;
import org.xml.sax.DocumentHandler;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public abstract class AbstractInternalContext
implements InternalContext {
    private static final Log LOG = LogFactory.getFactory().getInstance(AbstractInternalContext.class);
    private final PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private AbstractProperties _properties = XMLProperties.newInstance();
    private XMLClassDescriptorResolver _xmlClassDescriptorResolver;
    private Introspector _introspector;
    private ResolverStrategy _resolverStrategy;
    private MappingLoader _mappingLoader;
    private XMLNaming _xmlNaming;
    @Inject
    private JavaNaming _javaNaming = new JavaNamingImpl(this);
    private ClassLoader _classLoader;
    private NodeType _primitiveNodeType;
    private RegExpEvaluator _regExpEvaluator;

    @Override
    public void addMapping(Mapping mapping) throws MappingException {
        MappingUnmarshaller mappingUnmarshaller = new MappingUnmarshaller();
        MappingLoader mappingLoader = mappingUnmarshaller.getMappingLoader(mapping, BindingType.XML);
        this._xmlClassDescriptorResolver.setMappingLoader(mappingLoader);
    }

    @Override
    public void addClass(Class<?> clazz) throws ResolverException {
        this._xmlClassDescriptorResolver.addClass(clazz);
    }

    @Override
    public void addClasses(Class<?>[] clazzes) throws ResolverException {
        this._xmlClassDescriptorResolver.addClasses(clazzes);
    }

    @Override
    public void addPackage(String packageName) throws ResolverException {
        this._xmlClassDescriptorResolver.addPackage(packageName);
    }

    @Override
    public void addPackages(String[] packageNames) throws ResolverException {
        this._xmlClassDescriptorResolver.addPackages(packageNames);
    }

    @Override
    public void setResolver(XMLClassDescriptorResolver xmlClassDescriptorResolver) {
        this._xmlClassDescriptorResolver = xmlClassDescriptorResolver;
    }

    @Override
    public void setProperty(String propertyName, Object value) {
        if (propertyName == null) {
            IllegalArgumentException iae = new IllegalArgumentException("setProperty must not be called with a propertyName == null");
            LOG.warn(iae.getMessage());
            throw iae;
        }
        if (propertyName.equals("org.exolab.castor.xml.naming")) {
            if (value instanceof String) {
                this.setXMLNaming((String)value);
            } else if (value instanceof XMLNaming) {
                this.setXMLNaming((XMLNaming)value);
            } else {
                IllegalArgumentException iae = new IllegalArgumentException("XML Naming can only be set to a String or an implementation of XMLNaming");
                LOG.warn(iae.getMessage());
                throw iae;
            }
        }
        if (propertyName.equals("org.castor.xml.java.naming")) {
            if (value instanceof String) {
                this.setJavaNaming((String)value);
            } else if (value instanceof JavaNaming) {
                this.setJavaNaming((JavaNaming)value);
            } else {
                IllegalArgumentException iae = new IllegalArgumentException("Java Naming can only be set to a String or an implementation of JavaNaming");
                LOG.warn(iae.getMessage());
                throw iae;
            }
        }
        this._primitiveNodeType = null;
        this._regExpEvaluator = null;
        this.setPropertyInternal(propertyName, value);
    }

    @Override
    public Object getProperty(String propertyName) {
        return this._properties.getObject(propertyName);
    }

    @Override
    public XMLNaming getXMLNaming() {
        if (this._xmlNaming != null) {
            return this._xmlNaming;
        }
        String prop = this._properties.getString("org.exolab.castor.xml.naming", null);
        this.setXMLNaming(prop);
        return this._xmlNaming;
    }

    @Override
    public XMLNaming getXMLNaming(ClassLoader classLoader) {
        return this.getXMLNaming();
    }

    @Override
    public JavaNaming getJavaNaming() {
        return this._javaNaming;
    }

    @Override
    public Parser getParser() {
        return this.getParser(null);
    }

    @Override
    public Parser getParser(String features) {
        return XMLParserUtils.getParser(this._properties, features);
    }

    @Override
    public XMLReader getXMLReader() {
        return this.getXMLReader(null);
    }

    @Override
    public XMLReader getXMLReader(String features) {
        SAXParser saxParser;
        XMLReader reader = null;
        Boolean validation = this._properties.getBoolean("org.exolab.castor.parser.validation");
        Boolean namespaces = this._properties.getBoolean("org.exolab.castor.parser.namespaces");
        String readerClassName = this._properties.getString("org.exolab.castor.parser");
        if ((readerClassName == null || readerClassName.length() == 0) && (saxParser = XMLParserUtils.getSAXParser(validation, namespaces)) != null) {
            try {
                reader = saxParser.getXMLReader();
            }
            catch (SAXException e) {
                LOG.error(Messages.format("conf.configurationError", e));
            }
        }
        if (reader == null) {
            if (readerClassName == null || readerClassName.length() == 0 || readerClassName.equalsIgnoreCase("xerces")) {
                readerClassName = "org.apache.xerces.parsers.SAXParser";
            }
            reader = XMLParserUtils.instantiateXMLReader(readerClassName);
        }
        XMLParserUtils.setFeaturesOnXmlReader(this._properties.getString("org.exolab.castor.sax.features", features), this._properties.getString("org.exolab.castor.sax.features-to-disable", ""), validation, namespaces, reader);
        return reader;
    }

    @Override
    public NodeType getPrimitiveNodeType() {
        if (this._primitiveNodeType != null) {
            return this._primitiveNodeType;
        }
        String prop = this._properties.getString("org.exolab.castor.xml.introspector.primitive.nodetype", null);
        if (prop == null) {
            return null;
        }
        this._primitiveNodeType = NodeType.getNodeType(prop);
        return this._primitiveNodeType;
    }

    @Override
    public RegExpEvaluator getRegExpEvaluator() {
        if (this._regExpEvaluator != null) {
            return this._regExpEvaluator;
        }
        String className = this._properties.getString("org.exolab.castor.regexp", "");
        if (className.length() == 0) {
            this._regExpEvaluator = null;
        } else {
            try {
                Class<?> regExpEvalClass = Class.forName(className);
                this._regExpEvaluator = (RegExpEvaluator)regExpEvalClass.newInstance();
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(Messages.format("conf.failedInstantiateRegExp", className, e));
            }
            catch (InstantiationException e) {
                throw new RuntimeException(Messages.format("conf.failedInstantiateRegExp", className, e));
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(Messages.format("conf.failedInstantiateRegExp", className, e));
            }
        }
        return this._regExpEvaluator;
    }

    @Override
    public Serializer getSerializer() {
        return XMLParserUtils.getSerializer(this._properties);
    }

    @Override
    public OutputFormat getOutputFormat() {
        return XMLParserUtils.getOutputFormat(this._properties);
    }

    protected XMLSerializerFactory getSerializerFactory(String serializerFactoryName) {
        return XMLParserUtils.getSerializerFactory(serializerFactoryName);
    }

    @Override
    public DocumentHandler getSerializer(OutputStream output) throws IOException {
        Serializer serializer = this.getSerializer();
        serializer.setOutputByteStream(output);
        DocumentHandler docHandler = serializer.asDocumentHandler();
        if (docHandler == null) {
            throw new RuntimeException(Messages.format("conf.serializerNotSaxCapable", serializer.getClass().getName()));
        }
        return docHandler;
    }

    @Override
    public DocumentHandler getSerializer(Writer output) throws IOException {
        Serializer serializer = this.getSerializer();
        serializer.setOutputCharStream(output);
        DocumentHandler docHandler = serializer.asDocumentHandler();
        if (docHandler == null) {
            throw new RuntimeException(Messages.format("conf.serializerNotSaxCapable", serializer.getClass().getName()));
        }
        return docHandler;
    }

    @Override
    public XMLClassDescriptorResolver getXMLClassDescriptorResolver() {
        return this._xmlClassDescriptorResolver;
    }

    @Override
    public Introspector getIntrospector() {
        return this._introspector;
    }

    @Override
    public ResolverStrategy getResolverStrategy() {
        return this._resolverStrategy;
    }

    @Override
    public void setResolverStrategy(ResolverStrategy resolverStrategy) {
        this._resolverStrategy = resolverStrategy;
    }

    @Override
    public void setMappingLoader(MappingLoader mappingLoader) {
        this._mappingLoader = mappingLoader;
    }

    @Override
    public MappingLoader getMappingLoader() {
        return this._mappingLoader;
    }

    @Override
    public void setJavaNaming(JavaNaming javaNaming) {
        this._javaNaming = javaNaming;
    }

    public void setJavaNaming(String javaNamingProperty) {
        if (javaNamingProperty == null || javaNamingProperty.length() == 0) {
            this._javaNaming = new JavaNamingImpl(this);
        } else {
            try {
                Class<?> cls = Class.forName(javaNamingProperty);
                this._javaNaming = (JavaNaming)cls.newInstance();
            }
            catch (Exception e) {
                IllegalArgumentException iae = new IllegalArgumentException("Failed to load JavaNaming: " + e);
                LOG.warn(iae.getMessage());
                throw iae;
            }
        }
    }

    @Override
    public void setXMLNaming(XMLNaming xmlNaming) {
        this._xmlNaming = xmlNaming;
        if (this._introspector != null) {
            this._introspector.setNaming(this._xmlNaming);
        }
    }

    public void setXMLNaming(String xmlNamingProperty) {
        if (xmlNamingProperty == null || xmlNamingProperty.equalsIgnoreCase("lower")) {
            this.setXMLNaming(new DefaultNaming());
        } else if (xmlNamingProperty.equalsIgnoreCase("mixed")) {
            DefaultNaming dn = new DefaultNaming();
            dn.setStyle((short)1);
            this.setXMLNaming(dn);
        } else {
            try {
                Class<?> cls = Class.forName(xmlNamingProperty);
                this.setXMLNaming((XMLNaming)cls.newInstance());
            }
            catch (Exception e) {
                IllegalArgumentException iae = new IllegalArgumentException("Failed to load XMLNaming: " + e);
                LOG.warn(iae.getMessage());
                throw iae;
            }
        }
        if (this._xmlNaming == null) {
            IllegalArgumentException iae = new IllegalArgumentException("Failed to correctly set XMLNaming; property was: " + xmlNamingProperty);
            LOG.warn(iae.getMessage());
            throw iae;
        }
    }

    @Override
    public void setProperty(String propertyName, boolean value) {
        this.setPropertyInternal(propertyName, value);
    }

    private void setPropertyInternal(String propertyName, Object value) {
        Object oldValue = this._properties.getObject(propertyName);
        if (oldValue == null) {
            if (value != null) {
                this._properties.put(propertyName, value);
                this.propertyChangeSupport.firePropertyChange(propertyName, oldValue, value);
            }
        } else if (!oldValue.equals(value)) {
            this._properties.put(propertyName, value);
            this.propertyChangeSupport.firePropertyChange(propertyName, oldValue, value);
        }
    }

    @Override
    public Boolean getBooleanProperty(String propertyName) {
        return this._properties.getBoolean(propertyName);
    }

    @Override
    public String getStringProperty(String propertyName) {
        return this._properties.getString(propertyName);
    }

    @Override
    public void setClassLoader(ClassLoader classLoader) {
        this._classLoader = classLoader;
        if (this._xmlClassDescriptorResolver != null) {
            this._xmlClassDescriptorResolver.setClassLoader(classLoader);
        }
    }

    @Override
    public void setXMLClassDescriptorResolver(XMLClassDescriptorResolver xmlClassDescriptorResolver) {
        this._xmlClassDescriptorResolver = xmlClassDescriptorResolver;
    }

    @Override
    public void setIntrospector(Introspector introspector) {
        this._introspector = introspector;
    }

    @Override
    public ClassLoader getClassLoader() {
        return this._classLoader;
    }

    @Override
    public boolean getLenientIdValidation() {
        Boolean lenientIdValidation = this._properties.getBoolean("org.exolab.castor.xml.lenient.id.validation");
        if (lenientIdValidation == null) {
            String message = "Property lenientIdValidation must not be null";
            LOG.warn(message);
            throw new IllegalStateException(message);
        }
        return lenientIdValidation;
    }

    @Override
    public boolean getLenientSequenceOrder() {
        Boolean lenientSequenceOrder = this._properties.getBoolean("org.exolab.castor.xml.lenient.sequence.order");
        if (lenientSequenceOrder == null) {
            String message = "Property lenientSequenceOrder must not be null";
            LOG.warn(message);
            throw new IllegalStateException(message);
        }
        return lenientSequenceOrder;
    }

    @Override
    public Boolean getLoadPackageMapping() {
        return this._properties.getBoolean("org.exolab.castor.xml.loadPackageMappings");
    }

    @Override
    public void setLoadPackageMapping(Boolean loadPackageMapping) {
        this._properties.put("org.exolab.castor.xml.loadPackageMappings", loadPackageMapping);
    }

    @Override
    public Boolean getUseIntrospector() {
        return this._properties.getBoolean("org.castor.xml.class-resolver.use-introspection");
    }

    @Override
    public void setUseIntrospector(Boolean useIntrospector) {
        this._properties.put("org.castor.xml.class-resolver.use-introspection", useIntrospector);
    }

    @Override
    public boolean marshallingValidation() {
        Boolean marshallingValidation = this._properties.getBoolean("org.exolab.castor.marshalling.validation");
        if (marshallingValidation == null) {
            String message = "Property marshallingValidation must not be null";
            LOG.warn(message);
            throw new IllegalStateException(message);
        }
        return marshallingValidation;
    }

    @Override
    public boolean strictElements() {
        Boolean strictElements = this._properties.getBoolean("org.exolab.castor.xml.strictelements");
        if (strictElements == null) {
            String message = "Property strictElements must not be null";
            LOG.warn(message);
            throw new IllegalStateException(message);
        }
        return strictElements;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    @Override
    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyName, listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(propertyName, listener);
    }
}

