/*
 * Decompiled with CFR 0.152.
 */
package org.josast.ApplicationKissTool;

import org.josast.property.CONFIG;

public class Configuration {
    private String callsign = "Anonymous";
    private String longitude = "0.0W";
    private String latitude = "0.0N";
    private String soundModemIP = "127.0.0.1";
    private String soundModemPort = "8100";
    private String SIDSAMSATSource = "Anonymous";
    private String SIDSAMSATUrl = "https://amsat.electrolab.fr/api/V2/SIDS";
    private String SIDSSatnogsSource = "Anonymous";
    private String SIDSSatnogsURL = "https://db.satnogs.org/api/telemetry/";
    private String SIDSSatnogs = "0";
    private String SIDSPicsatsURL = "https://picsat.obspm.fr/sids/reportframe?";
    private String SIDSPicsat = "0";
    private String SIDSAMSAT = "1";
    private boolean SISD_SatNogs = false;
    private boolean SIDS_AMSAT = true;
    private boolean Silent_Mode = false;
    private String SilentMode = "0";
    private String OutputFileDirectory = ".";
    private int Norad = 99999;
    private String norads = null;
    private final CONFIG conf = CONFIG.getInstance();
    private boolean SIDS_Picsat = false;
    private String SIDSPicsatSource = "Anonymous";
    private String rawFile = "0";
    private String jsonFile = "0";
    private boolean rawFileBoolean = false;
    private boolean jsonFileBoolean = false;

    public static Configuration getInstance() {
        return SingletonHolder.instance;
    }

    public boolean isSISD_SatNogs() {
        return this.SISD_SatNogs;
    }

    private Configuration() {
        if (this.conf.getProperty("Callsign") != null) {
            this.callsign = this.conf.getProperty("Callsign");
            this.latitude = this.conf.getProperty("Latitude");
            this.longitude = this.conf.getProperty("Longitude");
            this.norads = this.conf.getProperty("Norad");
            this.SIDSAMSATSource = this.conf.getProperty("SIDSAMSATSource");
            this.SIDSAMSATUrl = this.conf.getProperty("SIDSAMSATUrl");
            this.SIDSSatnogsSource = this.conf.getProperty("SIDSSatnogsSource");
            this.SIDSPicsatSource = this.conf.getProperty("SIDSPicsatSource");
            this.SIDSSatnogsURL = this.conf.getProperty("SIDSSatnogsURL");
            this.SIDSPicsatsURL = this.conf.getProperty("SIDSPicsatsURL");
            this.SIDSSatnogs = this.conf.getProperty("SIDSSatnogs");
            this.SIDSAMSAT = this.conf.getProperty("SIDSAMSAT");
            this.SIDSPicsat = this.conf.getProperty("SIDSPicsat");
            this.soundModemIP = this.conf.getProperty("soundModemIP");
            this.soundModemPort = this.conf.getProperty("soundModemPort");
            this.OutputFileDirectory = this.conf.getProperty("OutputFileDirectory");
            this.SilentMode = this.conf.getProperty("SilentMode");
            this.rawFile = this.conf.getProperty("rawFile");
            this.jsonFile = this.conf.getProperty("jsonFile");
            this.rawFileBoolean = !this.rawFile.contentEquals("0");
            this.jsonFileBoolean = !this.jsonFile.contentEquals("0");
            if (this.norads != null) {
                this.Norad = Integer.parseInt(this.norads);
            }
            this.SISD_SatNogs = this.SIDSSatnogs.contentEquals("1");
            this.SIDS_AMSAT = this.SIDSAMSAT.contentEquals("1");
            this.SIDS_Picsat = this.SIDSPicsat.contentEquals("1");
            this.Silent_Mode = this.SilentMode.contentEquals("1");
        } else {
            this.save();
        }
    }

    public void setSIDSSatnogs(String sIDSSatnogs) {
        this.SIDSSatnogs = sIDSSatnogs;
        this.SISD_SatNogs = this.SIDSSatnogs.contentEquals("1");
    }

    public void setSIDSPicsat(String sSIDSPicsat) {
        this.SIDSPicsat = sSIDSPicsat;
        this.SIDS_Picsat = this.SIDSPicsat.contentEquals("1");
    }

    public void setSIDSAMSAT(String sIDSEntrySat) {
        this.SIDSAMSAT = sIDSEntrySat;
        this.SIDS_AMSAT = this.SIDSAMSAT.contentEquals("1");
    }

    public void save() {
        this.conf.setProperty("Norad", "" + this.Norad);
        this.conf.setProperty("Callsign", this.callsign);
        this.conf.setProperty("Latitude", this.latitude);
        this.conf.setProperty("Longitude", this.longitude);
        this.conf.setProperty("SIDSAMSATSource", this.SIDSAMSATSource);
        this.conf.setProperty("SIDSPicsatSource", this.SIDSPicsatSource);
        this.conf.setProperty("SIDSAMSATUrl", this.SIDSAMSATUrl);
        this.conf.setProperty("SIDSSatnogsSource", this.SIDSSatnogsSource);
        this.conf.setProperty("SIDSSatnogsURL", this.SIDSSatnogsURL);
        this.conf.setProperty("SIDSPicsatsURL", this.SIDSPicsatsURL);
        this.conf.setProperty("SIDSSatnogs", this.SIDSSatnogs);
        this.conf.setProperty("SIDSPicsat", this.SIDSPicsat);
        this.conf.setProperty("SIDSAMSAT", this.SIDSAMSAT);
        this.conf.setProperty("soundModemPort", this.soundModemPort);
        this.conf.setProperty("soundModemIP", this.soundModemIP);
        this.conf.setProperty("OutputFileDirectory", this.OutputFileDirectory);
        this.conf.setProperty("SilentMode", this.SilentMode);
        this.conf.setProperty("rawFile", this.rawFile);
        this.conf.setProperty("jsonFile", this.jsonFile);
    }

    public String getCallsign() {
        return this.callsign;
    }

    public void setCallsign(String callsign2) {
        this.callsign = callsign2;
    }

    public String getLongitude() {
        return this.longitude;
    }

    public void setLongitude(String longitude) {
        this.longitude = longitude;
    }

    public String getLatitude() {
        return this.latitude;
    }

    public void setLatitude(String latitude) {
        this.latitude = latitude;
    }

    public String getSoundModemIP() {
        return this.soundModemIP;
    }

    public void setSoundModemIP(String soundModemIP) {
        this.soundModemIP = soundModemIP;
    }

    public String getSoundModemPort() {
        return this.soundModemPort;
    }

    public void setSoundModemPort(String soundModemPort) {
        this.soundModemPort = soundModemPort;
    }

    public String getSIDSAMSATSource() {
        return this.SIDSAMSATSource;
    }

    public void setSIDSAMSATSource(String sIDSAMSATSource) {
        this.SIDSAMSATSource = sIDSAMSATSource;
    }

    public String getSIDSAMSATUrl() {
        return this.SIDSAMSATUrl;
    }

    public void setSIDSAMSATUrl(String sIDSAMSATUrl) {
        this.SIDSAMSATUrl = sIDSAMSATUrl;
    }

    public String getSIDSSatnogsSource() {
        return this.SIDSSatnogsSource;
    }

    public void setSIDSSatnogsSource(String sIDSSatnogsSource) {
        this.SIDSSatnogsSource = sIDSSatnogsSource;
    }

    public String getSIDSSatnogsURL() {
        return this.SIDSSatnogsURL;
    }

    public void setSIDSSatnogsURL(String sIDSSatnogsURL) {
        this.SIDSSatnogsURL = sIDSSatnogsURL;
    }

    public String getSIDSPicsatsURL() {
        return this.SIDSPicsatsURL;
    }

    public void setSIDSPicsatsURL(String sIDSPicsatsURL) {
        this.SIDSPicsatsURL = sIDSPicsatsURL;
    }

    public boolean isSIDS_AMSAT() {
        return this.SIDS_AMSAT;
    }

    public boolean isSIDS_Picsat() {
        return this.SIDS_Picsat;
    }

    public void setSISD_SatNogs(boolean sISD_SatNogs) {
        this.SISD_SatNogs = sISD_SatNogs;
    }

    public int getNorad() {
        return this.Norad;
    }

    public void setNorad(int norad) {
        this.Norad = norad;
    }

    public boolean isSilentMode() {
        return this.Silent_Mode;
    }

    public void setSilentMode(boolean silentMode) {
        this.Silent_Mode = silentMode;
        this.SilentMode = this.Silent_Mode ? "1" : "O";
    }

    public String getOutputFileDirectory() {
        return this.OutputFileDirectory;
    }

    public void setOutputFileDirectory(String outputFileDirectory) {
        this.OutputFileDirectory = outputFileDirectory;
    }

    public String getSIDSPicsatSource() {
        return this.SIDSPicsatSource;
    }

    public void setSIDSPicsatSource(String sSIDSPicsatSource) {
        this.SIDSPicsatSource = sSIDSPicsatSource;
    }

    public final synchronized boolean isRawFileBoolean() {
        return this.rawFileBoolean;
    }

    public final synchronized void setRawFileBoolean(boolean rawFileBoolean) {
        this.rawFileBoolean = rawFileBoolean;
        this.rawFile = rawFileBoolean ? "1" : "0";
    }

    public final synchronized boolean isJsonFileBoolean() {
        return this.jsonFileBoolean;
    }

    public final synchronized void setJsonFileBoolean(boolean jsonFileBoolean) {
        this.jsonFileBoolean = jsonFileBoolean;
        this.jsonFile = jsonFileBoolean ? "1" : "0";
    }

    private static class SingletonHolder {
        private static final Configuration instance = new Configuration();

        private SingletonHolder() {
        }
    }
}

