/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.xml;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exolab.castor.xml.UnmarshalHandler;
import org.exolab.castor.xml.UnmarshalState;
import org.xml.sax.SAXException;

public class CharactersProcessor {
    private static final Log LOG = LogFactory.getLog(CharactersProcessor.class);
    protected static ResourceBundle resourceBundle = ResourceBundle.getBundle("UnmarshalHandlerMessages", Locale.getDefault());
    private final UnmarshalHandler _unmarshalHandler;

    public CharactersProcessor(UnmarshalHandler unmarshalHandler) {
        this._unmarshalHandler = unmarshalHandler;
    }

    public void compute(char[] ch, int start, int length) throws SAXException {
        String string = new String(ch, start, length);
        if (LOG.isTraceEnabled()) {
            String trace = MessageFormat.format(resourceBundle.getString("unmarshalHandler.log.trace.characters"), string);
            LOG.trace(trace);
        }
        if (this._unmarshalHandler.getStrictElementHandler().skipElement()) {
            return;
        }
        if (this._unmarshalHandler.getStateStack().isEmpty()) {
            return;
        }
        if (this._unmarshalHandler.getAnyNodeHandler().hasAnyUnmarshaller()) {
            this._unmarshalHandler.getAnyNodeHandler().characters(ch, start, length);
            return;
        }
        UnmarshalState state = this._unmarshalHandler.getStateStack().getLastState();
        boolean removedTrailingWhitespace = false;
        boolean removedLeadingWhitespace = false;
        if (!state.isWhitespacePreserving() && !ArrayUtils.isEmpty(ch)) {
            removedTrailingWhitespace = Character.isWhitespace(ch[start + length - 1]);
            removedLeadingWhitespace = Character.isWhitespace(ch[start]);
            string = string.trim();
        }
        if (state.getBuffer() == null) {
            state.setBuffer(new StringBuffer());
        } else {
            if (state.isWhitespacePreserving()) {
                state.setTrailingWhitespaceRemoved(false);
                state.getBuffer().append(string);
                return;
            }
            if (StringUtils.isEmpty(string)) {
                state.setTrailingWhitespaceRemoved(removedTrailingWhitespace);
                return;
            }
            if (state.isTrailingWhitespaceRemoved() || removedLeadingWhitespace) {
                state.getBuffer().append(' ');
            }
        }
        state.setTrailingWhitespaceRemoved(removedTrailingWhitespace);
        state.getBuffer().append(string);
    }
}

