/*
 * Decompiled with CFR 0.152.
 */
package org.buildobjects.process;

import java.io.InputStream;
import org.buildobjects.process.EventSink;
import org.buildobjects.process.ExecutionEvent;
import org.buildobjects.process.OutputConsumptionThread;
import org.buildobjects.process.StreamConsumer;

class StreamConsumerConsumptionThread
implements OutputConsumptionThread {
    private final EventSink eventSink;
    private final StreamConsumer stdout;
    private Thread thread;
    private Throwable throwable;

    public StreamConsumerConsumptionThread(EventSink eventSink, StreamConsumer stdout) {
        this.eventSink = eventSink;
        this.stdout = stdout;
    }

    public void startConsumption(final InputStream inputStream) {
        this.thread = new Thread(new Runnable(){

            public void run() {
                try {
                    StreamConsumerConsumptionThread.this.stdout.consume(inputStream);
                }
                catch (Throwable t) {
                    StreamConsumerConsumptionThread.this.throwable = t;
                    StreamConsumerConsumptionThread.this.eventSink.dispatch(ExecutionEvent.EXCEPTION_IN_STREAM_HANDLING);
                }
            }
        });
        this.thread.start();
    }

    public void join() throws InterruptedException {
        this.thread.join();
    }

    public void interrupt() {
        this.thread.interrupt();
    }

    public Throwable getThrowable() {
        return this.throwable;
    }
}

