/*
 * Decompiled with CFR 0.152.
 */
package org.josast.ApplicationKissTool;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.TimeZone;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Platform;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.concurrent.WorkerStateEvent;
import javafx.embed.swing.SwingFXUtils;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.Tab;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.image.ImageView;
import javafx.scene.image.WritableImage;
import javafx.scene.paint.Color;
import javafx.scene.shape.Circle;
import javafx.scene.web.WebEngine;
import javafx.scene.web.WebView;
import javafx.stage.DirectoryChooser;
import javafx.stage.Stage;
import javafx.stage.Window;
import javax.imageio.ImageIO;
import org.josast.ApplicationKissTool.AlertHelper;
import org.josast.ApplicationKissTool.Configuration;
import org.josast.ApplicationKissTool.ManageDataFile;
import org.josast.ApplicationKissTool.ReceivedData;
import org.josast.ApplicationKissTool.SatelliteNorad;
import org.josast.ApplicationKissTool.SatelliteNoradFile;
import org.josast.ApplicationKissTool.SendSIDS;
import org.josast.ApplicationKissTool.TaskManageReceivedData;
import org.josast.ApplicationKissTool.TaskSoundmodemTCP;
import org.josast.ModuleSoundModem.SoundModemConfiguration;
import org.josast.SIDS.Station;
import org.josast.propertyHttp.ConfigHttp;
import org.josast.telemetry.DataTelemetry;

public class Controler {
    private static final int STATE_INIT = 0;
    private static final int STATE_START = 1;
    protected static final int STATE_STOP = 2;
    private static final int STATE_SAVE = 3;
    private int delayRefresh = 15;
    private static Logger appLogger = Logger.getLogger("AmsatLogger");
    ConfigHttp c = new ConfigHttp("http://site.amsat-f.org/download/117487/");
    private final SimpleDateFormat ISO8601DATEFORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
    private ManageDataFile mdf = new ManageDataFile();
    private String version = "2.0";
    @FXML
    private Button ButtonStart;
    @FXML
    private Button ButtonStop;
    @FXML
    private Button buttonFileChoiser;
    @FXML
    private TextField TextFielRepository;
    @FXML
    private Label LabelIP;
    @FXML
    private CheckBox checkboxSilenceMode;
    @FXML
    private Button ButtonFile;
    @FXML
    private Button ButtonSerial;
    @FXML
    private Button ButtonKiss;
    @FXML
    private TextField FieldIP;
    @FXML
    private TextField FieldPort;
    @FXML
    private Label labelStatus;
    @FXML
    private Label LabelFrame;
    @FXML
    private TextArea DecodedData;
    @FXML
    private TextArea TexAreaLog;
    @FXML
    private TextField textFieldMode;
    @FXML
    private TextField textFieldDate;
    @FXML
    private Label LabelInformation;
    @FXML
    private ImageView ImageViewAMSAT;
    @FXML
    private ImageView imageViewEntrysat;
    @FXML
    private TextField TextFieldCallsign;
    @FXML
    private TextField TextFieldLatitude;
    @FXML
    private TextField TextFieldLongitude;
    @FXML
    private CheckBox CheckbBoxAmicalSat;
    @FXML
    private CheckBox CheckBoxSatNogs;
    @FXML
    private CheckBox CheckBoxSatPicsat;
    @FXML
    private Button ButtonSaveConfiguration;
    @FXML
    private TextField TextFieldSIDSEntrysat;
    @FXML
    private TextField TextFieldSIDSSatnogs;
    @FXML
    private TextField TextFieldSIDSPicsat;
    @FXML
    private Circle CircleModem;
    @FXML
    private Circle CircleDatabaseSatnogs;
    @FXML
    private Circle CircleDatabasePicsat;
    @FXML
    private Circle CircleDatabaseAmsatF;
    @FXML
    private ComboBox<SatelliteNorad> ComboBoxSatellite;
    @FXML
    private Label LabelAmsatSent;
    @FXML
    private Label LabelPicsatSent;
    @FXML
    private Label LabelSatnogsSent;
    @FXML
    private Label LastDecoded;
    @FXML
    private CheckBox CheckBoxJsonFile;
    @FXML
    private CheckBox CheckBoxrawfile;
    @FXML
    private TableColumn<DataTelemetry, String> tbcolumnName;
    @FXML
    private TableColumn<DataTelemetry, String> tbcolumnValue;
    @FXML
    private TableView<DataTelemetry> TableviewTelemery;
    @FXML
    private TextField labelFrameName;
    @FXML
    private WebView WebViewInfo;
    @FXML
    private Tab infoTab;
    ScheduledExecutorService ses = Executors.newScheduledThreadPool(1);
    private ScheduledFuture<?> scheduledFuture = null;
    private volatile BlockingQueue<ReceivedData> receivedFrame = new LinkedBlockingDeque<ReceivedData>();
    Stage primaryStage = null;
    private String imgAmsat = "logoAmsat.png";
    private String imgAmicalsat = "OIP.jpg";
    private int selectedNoradId;
    Station station = new Station();
    private final Configuration conf = Configuration.getInstance();
    private TaskSoundmodemTCP task;
    private SendSIDS SendSIDSSatnogs;
    private SendSIDS SendSIDSMVPAmsat;
    private SendSIDS SendSIDSPicsat;
    private TaskManageReceivedData taskMngtData;
    private long nbframeTraited = 0L;
    private long nbframe = 0L;
    private long nbAmsatDatabase = 0L;
    private long nbSatnogsDatabase = 0L;
    private long picsatDatabase = 0L;
    private SatelliteNoradFile satnorad;

    public void setReceivedFrame(BlockingQueue<ReceivedData> receivedFrame) {
        this.receivedFrame = receivedFrame;
    }

    @FXML
    private void HandleSilentMode(ActionEvent event) {
        if (this.checkboxSilenceMode.isSelected()) {
            this.conf.setSilentMode(true);
            this.conf.save();
            this.displayLog("Silent Mode activated");
        } else {
            this.conf.setSilentMode(false);
            this.conf.save();
            this.displayLog("Silent Mode deactivated");
        }
    }

    @FXML
    private void HandleSaveConfiguration(ActionEvent event) {
        String erreurmsg = null;
        String Callsign2 = null;
        if (this.TextFieldCallsign.getText().isEmpty()) {
            erreurmsg = erreurmsg + "please enter a CallSign \r\n";
        } else {
            Callsign2 = this.TextFieldCallsign.getText();
        }
        String Latitude = this.TextFieldLatitude.getText();
        String Longitude = this.TextFieldLongitude.getText();
        if (!this.station.checkLatitude(Latitude)) {
            erreurmsg = erreurmsg + "Wrong format for Latitude : XX.XXE/W \r\n";
        }
        if (!this.station.checkLongitude(Longitude)) {
            erreurmsg = erreurmsg + "Wrong format for Longitude : XX.XXS/N \r\n";
        }
        if (erreurmsg != null) {
            Window owner = this.ButtonSaveConfiguration.getScene().getWindow();
            AlertHelper.showAlert(Alert.AlertType.ERROR, owner, "Form Error!", erreurmsg);
            return;
        }
        this.station.setCallsign(Callsign2);
        this.station.setLatitude(Latitude);
        this.station.setLongitude(Longitude);
        this.conf.setCallsign(Callsign2);
        this.conf.setLatitude(Latitude);
        this.conf.setLongitude(Longitude);
        this.conf.setSIDSAMSATSource(this.TextFieldSIDSEntrysat.getText());
        this.conf.setSIDSSatnogsSource(this.TextFieldSIDSSatnogs.getText());
        this.conf.setSIDSPicsatSource(this.TextFieldSIDSPicsat.getText());
        this.conf.setSoundModemIP(this.FieldIP.getText());
        this.conf.setSoundModemPort(this.FieldPort.getText());
        this.conf.setOutputFileDirectory(this.TextFielRepository.getText());
        this.conf.setSilentMode(this.checkboxSilenceMode.isSelected());
        if (this.checkboxSilenceMode.isSelected()) {
            appLogger.setLevel(Level.SEVERE);
        } else {
            appLogger.setLevel(Level.INFO);
        }
        Station StationSatnogs = new Station(this.conf.getSIDSSatnogsSource(), this.station.getLongitude(), this.station.getLatitude());
        Station StationEntry = new Station(this.conf.getSIDSAMSATSource(), this.station.getLongitude(), this.station.getLatitude());
        Station StationPicsat = new Station(this.conf.getSIDSPicsatSource(), this.station.getLongitude(), this.station.getLatitude());
        this.SendSIDSMVPAmsat = new SendSIDS(StationEntry, this.conf.getNorad(), this.conf.getSIDSAMSATUrl());
        this.SendSIDSPicsat = new SendSIDS(StationPicsat, this.conf.getNorad(), this.conf.getSIDSPicsatsURL());
        this.SendSIDSSatnogs = new SendSIDS(StationSatnogs, this.conf.getNorad(), this.conf.getSIDSSatnogsURL());
        if (this.CheckbBoxAmicalSat.isSelected()) {
            this.conf.setSIDSAMSAT("1");
        } else {
            this.conf.setSIDSAMSAT("0");
        }
        if (this.CheckBoxSatPicsat.isSelected()) {
            this.conf.setSIDSPicsat("1");
        } else {
            this.conf.setSIDSPicsat("0");
        }
        if (this.CheckBoxSatNogs.isSelected()) {
            this.conf.setSIDSSatnogs("1");
        } else {
            this.conf.setSIDSSatnogs("0");
        }
        this.conf.setRawFileBoolean(this.CheckBoxrawfile.isSelected());
        this.conf.setJsonFileBoolean(this.CheckBoxJsonFile.isSelected());
        this.conf.save();
        this.mdf.setRepositoryPath(this.conf.getOutputFileDirectory());
        this.manageStatusinformation("Configuration Saved", "Configuration Saved");
    }

    @FXML
    private void Handlefilechooser() {
        DirectoryChooser directoryChooser = new DirectoryChooser();
        File selectedDirectory = directoryChooser.showDialog(this.primaryStage);
        this.conf.setOutputFileDirectory(selectedDirectory.getAbsolutePath());
        this.TextFielRepository.setText(selectedDirectory.getAbsolutePath());
    }

    @FXML
    private void handleStart(ActionEvent event) {
        this.manageStatusinformation("Start Connected to modem", "Start Connection to modem");
        this.manageStateMMI(1);
        SoundModemConfiguration smc = new SoundModemConfiguration("configuration.ini");
        smc.setSmIPadress(this.FieldIP.getText());
        smc.setSmPort(Integer.parseInt(this.FieldPort.getText()));
        this.ISO8601DATEFORMAT.setTimeZone(TimeZone.getTimeZone("UTC"));
        this.task = new TaskSoundmodemTCP(smc, this.receivedFrame, this);
        this.displayLog("task  SoundModem Created");
        this.task.setOnSucceeded(new EventHandler<WorkerStateEvent>(){

            @Override
            public void handle(WorkerStateEvent event) {
                Controler.this.manageStatusinformation("KISS TCP CONNECTION FAILED", "KISS TCP DISCONNECTED");
                Controler.this.manageStateMMI(2);
                Controler.this.CircleModem.setFill(Color.RED);
            }
        });
        this.task.setOnFailed(new EventHandler<WorkerStateEvent>(){

            @Override
            public void handle(WorkerStateEvent event) {
                Controler.this.manageStatusinformation("KISS TCP CONNECTION FAILED", "KISS TCP DISCONNECTED - Connection failed");
                Controler.this.displayLog(event.toString());
                Controler.this.displayLog(event.getSource().toString());
                Controler.this.manageStateMMI(2);
                Controler.this.CircleModem.setFill(Color.RED);
            }
        });
        this.CircleModem.setFill(Color.GREEN);
        Thread backgroundThread = new Thread(this.task);
        backgroundThread.setDaemon(true);
        backgroundThread.setPriority(10);
        backgroundThread.start();
        this.manageStatusinformation(" Connected to modem", " Connection to modem");
    }

    @FXML
    private void handleStop(ActionEvent event) {
        this.manageStateMMI(2);
        this.task.arreter();
        this.manageStatusinformation("Stop received data", "Stop task to receive telemetrie");
    }

    @FXML
    private void handleSave(ActionEvent event) {
        this.manageStateMMI(3);
        this.manageStatusinformation("save data", "save Telemetry in file");
        this.manageStatusinformation("Data Saved", "Telemetry Data saved in file");
    }

    @FXML
    private void HandleIP(ActionEvent event) {
    }

    @FXML
    private void HandleSelectSatellite(ActionEvent event) {
        SatelliteNorad sat = (SatelliteNorad)this.ComboBoxSatellite.getSelectionModel().getSelectedItem();
        this.displayLog(sat.getName() + " " + sat.getNoradId());
        this.selectedNoradId = sat.getNoradId();
        this.conf.setNorad(this.selectedNoradId);
        this.conf.save();
    }

    @FXML
    private void HandlePort(ActionEvent event) {
    }

    public void initMMI() {
        String message;
        String ver;
        this.tbcolumnName.setCellValueFactory(new PropertyValueFactory("dataName"));
        this.tbcolumnValue.setCellValueFactory(new PropertyValueFactory("value"));
        this.manageStatusinformation("Initialised", "KISS TOOL  - LOG \r\n Initialise application");
        this.satnorad = new SatelliteNoradFile();
        this.satnorad.readFile("SatelliteNoradList.json");
        this.selectedNoradId = this.conf.getNorad();
        ObservableList<SatelliteNorad> list = FXCollections.observableArrayList(this.satnorad.getSatelliteNoradList());
        this.ComboBoxSatellite.setItems(list);
        this.ComboBoxSatellite.getSelectionModel().select(0);
        this.LabelAmsatSent.setText("0");
        this.LabelPicsatSent.setText("0");
        this.LabelSatnogsSent.setText("0");
        appLogger.severe("initialisation information");
        this.setupInfoTab();
        this.taskMngtData = new TaskManageReceivedData(this.receivedFrame, this);
        Thread backgroundThread = new Thread(this.taskMngtData);
        backgroundThread.setDaemon(true);
        backgroundThread.start();
        Runnable task1 = () -> {
            Date date = new Date();
            if (this.receivedFrame.size() != 0) {
                appLogger.severe("queue size greater than 0 : " + this.receivedFrame.size());
                appLogger.severe("State task" + backgroundThread.getState().name());
            }
        };
        this.scheduledFuture = this.ses.scheduleAtFixedRate(task1, this.delayRefresh, this.delayRefresh, TimeUnit.MINUTES);
        appLogger.warning("Initialise ");
        this.primaryStage.setTitle("KISS TOOL - " + this.version);
        int NoradIdConf = this.conf.getNorad();
        this.station.setCallsign(this.conf.getCallsign());
        this.station.setLatitude(this.conf.getLatitude());
        this.station.setLongitude(this.conf.getLongitude());
        this.TextFieldCallsign.setText(this.station.getCallsign());
        this.TextFieldLatitude.setText(this.station.getLatitude());
        this.TextFieldLongitude.setText(this.station.getLongitude());
        this.FieldIP.setText(this.conf.getSoundModemIP());
        this.FieldPort.setText(this.conf.getSoundModemPort());
        this.TextFieldSIDSEntrysat.setText(this.conf.getSIDSAMSATSource());
        this.TextFieldSIDSSatnogs.setText(this.conf.getSIDSSatnogsSource());
        this.TextFieldSIDSPicsat.setText(this.conf.getSIDSPicsatSource());
        this.TextFielRepository.setText(this.conf.getOutputFileDirectory());
        if (this.conf.isSIDS_AMSAT()) {
            this.CheckbBoxAmicalSat.setSelected(true);
        }
        if (this.conf.isSISD_SatNogs()) {
            this.CheckBoxSatNogs.setSelected(true);
        }
        if (this.conf.isSIDS_Picsat()) {
            this.CheckBoxSatPicsat.setSelected(true);
        }
        this.CheckBoxrawfile.setSelected(this.conf.isRawFileBoolean());
        this.CheckBoxJsonFile.setSelected(this.conf.isJsonFileBoolean());
        this.checkboxSilenceMode.setSelected(this.conf.isSilentMode());
        if (this.checkboxSilenceMode.isSelected()) {
            appLogger.setLevel(Level.SEVERE);
        } else {
            appLogger.setLevel(Level.INFO);
        }
        this.displayLog(this.conf.getSIDSSatnogsURL());
        this.displayLog(this.conf.getSIDSAMSATUrl());
        this.displayLog("Initialisation with Properties File Done ");
        BufferedImage bufferedImage1 = null;
        BufferedImage bufferedImage2 = null;
        try {
            bufferedImage1 = ImageIO.read(this.getClass().getResource(this.imgAmsat));
            bufferedImage2 = ImageIO.read(this.getClass().getResource(this.imgAmicalsat));
        }
        catch (IOException e) {
            appLogger.severe("Error loading Image resources");
            appLogger.severe(e.toString());
        }
        WritableImage imageamsat = SwingFXUtils.toFXImage(bufferedImage1, null);
        this.ImageViewAMSAT.setImage(imageamsat);
        WritableImage imgQB = SwingFXUtils.toFXImage(bufferedImage2, null);
        this.imageViewEntrysat.setImage(imgQB);
        if (this.c.isConnected()) {
            ver = this.c.getProperty("Kisstool");
            message = this.c.getProperty("Message");
            String noradid = this.c.getProperty("NoradID");
            if (noradid != null) {
                NoradIdConf = Integer.parseUnsignedInt(this.c.getProperty("NoradID").trim());
            }
        } else {
            ver = this.version;
            message = "not connected to internet";
        }
        if (NoradIdConf != 0 && NoradIdConf != this.conf.getNorad()) {
            this.conf.setNorad(NoradIdConf);
            this.conf.save();
            this.displayLog("Norad ID updated  ");
        }
        this.manageStateMMI(0);
        this.manageStatusinformation("Application Ready", "Application initialised");
        this.LabelInformation.setText("");
        Station StationSatnogs = new Station(this.conf.getSIDSSatnogsSource(), this.station.getLongitude(), this.station.getLatitude());
        Station StationEntry = new Station(this.conf.getSIDSAMSATSource(), this.station.getLongitude(), this.station.getLatitude());
        Station StationPicsat = new Station(this.conf.getSIDSPicsatSource(), this.station.getLongitude(), this.station.getLatitude());
        this.SendSIDSSatnogs = new SendSIDS(StationSatnogs, this.conf.getNorad(), this.conf.getSIDSSatnogsURL());
        this.SendSIDSMVPAmsat = new SendSIDS(StationEntry, this.conf.getNorad(), this.conf.getSIDSAMSATUrl());
        this.SendSIDSPicsat = new SendSIDS(StationPicsat, this.conf.getNorad(), this.conf.getSIDSPicsatsURL());
        Object erreurmsg = message;
        if (!ver.equals(this.version)) {
            erreurmsg = (String)erreurmsg + " New version " + ver + " available ! ";
        }
        this.LabelInformation.setText((String)erreurmsg);
        this.mdf.setRepositoryPath(this.conf.getOutputFileDirectory());
    }

    public void setPrimaryStage(Stage primaryStageIn) {
        this.primaryStage = primaryStageIn;
    }

    private void updateFrame() {
        this.LabelFrame.setText(" Received  : " + this.nbframe + " Processed : " + this.nbframeTraited + " Sent :  Amsat - " + this.nbAmsatDatabase);
        this.LabelAmsatSent.setText("" + this.nbAmsatDatabase);
        this.LabelPicsatSent.setText("" + this.picsatDatabase);
        this.LabelSatnogsSent.setText("" + this.nbSatnogsDatabase);
    }

    public void IncrementNbFrame() {
        ++this.nbframe;
        this.updateFrame();
    }

    public void IncrementNbFrameTraited() {
        ++this.nbframeTraited;
        this.updateFrame();
    }

    public void displayLog(String log) {
        appLogger.info(log);
        this.TexAreaLog.appendText(log);
        this.TexAreaLog.appendText("\r\n");
    }

    private void manageStateMMI(int state) {
        switch (state) {
            case 0: {
                this.ButtonStop.setDisable(true);
                this.ButtonStart.setDisable(false);
                break;
            }
            case 1: {
                this.ButtonStop.setDisable(false);
                this.ButtonStart.setDisable(true);
                break;
            }
            case 2: {
                this.ButtonStop.setDisable(true);
                this.ButtonStart.setDisable(false);
                break;
            }
            case 3: {
                this.ButtonStop.setDisable(true);
                this.ButtonStart.setDisable(false);
                break;
            }
            default: {
                this.ButtonStop.setDisable(true);
                this.ButtonStart.setDisable(false);
            }
        }
    }

    private void manageStatusinformation(String statusMessage, String logMessage) {
        this.labelStatus.setText(statusMessage);
        this.displayLog(logMessage);
    }

    public void SendSids(ReceivedData receivedData, int noradframe) {
        int results;
        this.LastDecoded.setText("" + noradframe);
        if (this.conf.isSIDS_AMSAT()) {
            results = this.SendSIDSMVPAmsat.send(receivedData, noradframe);
            if (this.SendSIDSMVPAmsat.isCorrectSend(results)) {
                this.CircleDatabaseAmsatF.setFill(Color.GREEN);
                ++this.nbAmsatDatabase;
            } else {
                this.CircleDatabaseAmsatF.setFill(Color.RED);
                this.displayLog("Send SIDS AMSAT-F Database ; " + results);
            }
        }
        if (this.conf.isSISD_SatNogs()) {
            results = this.SendSIDSSatnogs.send(receivedData, noradframe);
            if (this.SendSIDSSatnogs.isCorrectSend(results)) {
                this.CircleDatabaseSatnogs.setFill(Color.GREEN);
                ++this.nbSatnogsDatabase;
            } else {
                this.CircleDatabaseSatnogs.setFill(Color.RED);
                this.displayLog("Send SIDS SatNogs Database : " + results);
            }
        }
        if (this.conf.isSIDS_Picsat()) {
            results = this.SendSIDSPicsat.send(receivedData, noradframe);
            if (this.SendSIDSPicsat.isCorrectSend(results)) {
                this.CircleDatabasePicsat.setFill(Color.GREEN);
                ++this.picsatDatabase;
            } else {
                this.displayLog("Send SIDS Picsat Database : " + results);
                this.displayLog(this.SendSIDSPicsat.getMessageAnswer());
                this.CircleDatabasePicsat.setFill(Color.RED);
            }
        }
    }

    public String getVersion() {
        return this.version;
    }

    public void SetDecodedData(String data) {
        this.DecodedData.appendText(data);
    }

    public int getNorad(String rcvCallsign) {
        int norad = this.satnorad.getNorad(rcvCallsign);
        return norad;
    }

    @FXML
    private void HandleInfoTabChange() {
        Platform.runLater(new Runnable(){

            @Override
            public void run() {
                if (Controler.this.infoTab.isSelected()) {
                    Controler.this.setupInfoTab();
                }
            }
        });
    }

    private void setupInfoTab() {
        File f = new File("./KissToolHelp.html");
        WebEngine engine = this.WebViewInfo.getEngine();
        if (f.exists()) {
            File file = new File(f.getAbsolutePath());
            URL url = null;
            try {
                url = file.toURI().toURL();
                engine.load(url.toString());
            }
            catch (MalformedURLException e) {
                appLogger.severe("Error to acces to " + f.getName());
            }
        } else {
            appLogger.severe(f.getName() + "Not Found");
        }
        appLogger.severe(f.getName() + "loaded");
    }

    public void setDecodedTable(ArrayList<DataTelemetry> table, String tableName) {
        ObservableList<DataTelemetry> observableList = FXCollections.observableList(table);
        this.TableviewTelemery.getItems().clear();
        this.TableviewTelemery.setItems(observableList);
        this.labelFrameName.setText(tableName);
    }

    public String getName(String rcvCallsign) {
        return this.satnorad.getName(rcvCallsign);
    }
}

