/*
 * Decompiled with CFR 0.152.
 */
package org.josast.telemetry.api;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.ServiceLoader;
import org.josast.telemetry.api.TelemetryAnalysisInterface;

public class TelemetryAnalysisProvider {
    private Hashtable<String, TelemetryAnalysisInterface> dataAnalyser = new Hashtable();
    ServiceLoader<TelemetryAnalysisInterface> loader = ServiceLoader.load(TelemetryAnalysisInterface.class);

    public TelemetryAnalysisProvider() {
        this.loader.reload();
        for (TelemetryAnalysisInterface ta : this.loader) {
            this.dataAnalyser.put(ta.getSatelliteName(), ta);
        }
    }

    public Iterator<TelemetryAnalysisInterface> providers(boolean refresh) {
        if (refresh) {
            this.loader.reload();
        }
        return this.loader.iterator();
    }

    public void displayProviderNames() {
        System.out.println("Number of providers:");
        Iterator<TelemetryAnalysisInterface> listIt = this.loader.iterator();
        while (listIt.hasNext()) {
            System.out.println(listIt.next().getSatelliteName());
        }
    }

    public TelemetryAnalysisInterface getDataAnalyser(String satelliteName) {
        return this.dataAnalyser.get(satelliteName);
    }
}

