/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.xml;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.lang.reflect.Method;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.castor.core.util.Messages;
import org.exolab.castor.xml.OutputFormat;
import org.exolab.castor.xml.Serializer;
import org.xml.sax.DocumentHandler;

public abstract class BaseXercesJDK5Serializer
implements Serializer {
    private final Log LOG = LogFactory.getLog(this.getClass());
    private Object _serializer;

    public BaseXercesJDK5Serializer() {
        try {
            this._serializer = Class.forName(this.getPackageName() + ".XMLSerializer").newInstance();
        }
        catch (Exception except) {
            throw new RuntimeException(Messages.format("conf.failedInstantiateSerializer", this.getPackageName() + ".XMLSerializer", except));
        }
    }

    protected abstract String getPackageName();

    @Override
    public void setOutputCharStream(Writer out) {
        try {
            Method method = this._serializer.getClass().getMethod("setOutputCharStream", Writer.class);
            method.invoke(this._serializer, out);
        }
        catch (Exception e) {
            String msg = "Problem invoking XMLSerializer.setOutputCharStream()";
            this.LOG.error(msg, e);
            throw new RuntimeException(msg + e.getMessage());
        }
    }

    @Override
    public DocumentHandler asDocumentHandler() throws IOException {
        try {
            Method method = this._serializer.getClass().getMethod("asDocumentHandler", null);
            return (DocumentHandler)method.invoke(this._serializer, (Object[])null);
        }
        catch (Exception e) {
            String msg = "Problem invoking XMLSerializer.asDocumentHandler()";
            this.LOG.error(msg, e);
            throw new RuntimeException(msg + e.getMessage());
        }
    }

    @Override
    public void setOutputFormat(OutputFormat format) {
        try {
            Class<?> outputFormatClass = Class.forName(this.getPackageName() + ".OutputFormat");
            Method method = this._serializer.getClass().getMethod("setOutputFormat", outputFormatClass);
            method.invoke(this._serializer, format.getFormat());
        }
        catch (Exception e) {
            String msg = "Problem invoking XMLSerializer.setOutputFormat()";
            this.LOG.error(msg, e);
            throw new RuntimeException(msg + e.getMessage());
        }
    }

    @Override
    public void setOutputByteStream(OutputStream output) {
        try {
            Method method = this._serializer.getClass().getMethod("setOutputByteStream", OutputStream.class);
            method.invoke(this._serializer, output);
        }
        catch (Exception e) {
            String msg = "Problem invoking XMLSerializer.setOutputByteStream()";
            this.LOG.error(msg, e);
            throw new RuntimeException(msg + e.getMessage());
        }
    }
}

