/*
 * Decompiled with CFR 0.152.
 */
package org.josast.propertyHttp;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Properties;
import java.util.logging.Logger;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;

public class ConfigHttp {
    private static Logger log = Logger.getLogger("AmsatLogger");
    private String url = "";
    private Properties props = new Properties();
    private boolean connected = false;

    public ConfigHttp(String url) {
        this.url = url;
        try {
            this.loadProperties();
        }
        catch (Exception e) {
            log.severe(e.getMessage());
        }
    }

    private void loadProperties() {
        String USER_AGENT = "Mozilla/5.0";
        CloseableHttpClient client = HttpClientBuilder.create().build();
        HttpGet request = new HttpGet(this.url);
        request.addHeader("User-Agent", "Mozilla/5.0");
        try {
            HttpResponse response = client.execute(request);
            BufferedReader rd = new BufferedReader(new InputStreamReader(response.getEntity().getContent(), StandardCharsets.UTF_8));
            this.props.load(rd);
            this.connected = true;
            rd.close();
        }
        catch (ClientProtocolException e) {
            log.severe("Error read URL");
        }
        catch (IOException e) {
            log.severe("Error read URL ");
        }
    }

    public String getProperty(String Item2) {
        if (this.props != null) {
            String S = this.props.getProperty(Item2);
            if (S == null) {
                return null;
            }
            return S.trim();
        }
        return null;
    }

    public boolean isConnected() {
        return this.connected;
    }

    public static void main(String[] args) {
        ConfigHttp c = new ConfigHttp("http://site.amsat-f.org/download/117168/");
        System.out.println(c.getProperty("EntrySatVersion"));
    }
}

