/*
 * Decompiled with CFR 0.152.
 */
package name.valery1707.kaitai;

import java.io.File;
import java.net.URL;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import name.valery1707.kaitai.KaitaiException;
import name.valery1707.kaitai.KaitaiGenerator;
import name.valery1707.kaitai.KaitaiUtils;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Settings;
import org.slf4j.Logger;
import org.slf4j.impl.StaticLoggerBinder;

@Mojo(name="generate", defaultPhase=LifecyclePhase.GENERATE_SOURCES)
public class KaitaiMojo
extends AbstractMojo {
    static final String KAITAI_VERSION = "0.8";
    @Parameter(property="kaitai.version", defaultValue="0.8")
    private String version;
    @Parameter(property="kaitai.url")
    private URL url;
    @Parameter(property="kaitai.cache")
    private File cacheDir;
    @Parameter(property="kaitai.source", defaultValue="${project.build.sourceDirectory}/../resources/kaitai")
    private File sourceDirectory;
    @Parameter(property="kaitai.includes", defaultValue="*.ksy")
    private String[] includes;
    @Parameter(property="kaitai.excludes")
    private String[] excludes;
    @Parameter(property="kaitai.output", defaultValue="${project.build.directory}/generated-sources/kaitai")
    private File output;
    @Parameter(property="kaitai.exactOutput", defaultValue="false")
    private boolean exactOutput;
    @Parameter(property="kaitai.package", defaultValue="${project.groupId}")
    private String packageName;
    @Parameter(property="kaitai.skip", defaultValue="false")
    private boolean skip = false;
    @Parameter(property="kaitai.overwrite", defaultValue="false")
    private boolean overwrite = false;
    @Parameter(property="kaitai.execution.timeout", defaultValue="5000")
    private long executionTimeout;
    @Parameter(property="kaitai.fromFileClass")
    private String fromFileClass;
    @Parameter(property="kaitai.opaqueTypes")
    private Boolean opaqueTypes;
    @Parameter(property="kaitai.noVersionCheck", defaultValue="false")
    private boolean noVersionCheck;
    @Parameter(defaultValue="${settings}", readonly=true)
    private Settings settings;
    @Parameter(defaultValue="${session}", readonly=true)
    private MavenSession session;
    @Parameter(defaultValue="${project}", readonly=true)
    private MavenProject project;

    public void execute() throws MojoExecutionException {
        try {
            this.executeInt();
        }
        catch (KaitaiException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
    }

    private void executeInt() throws KaitaiException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Skip KaiTai generation: skip=true");
            return;
        }
        this.sourceDirectory = this.sourceDirectory.toPath().normalize().toFile();
        if (!this.sourceDirectory.exists()) {
            this.getLog().warn((CharSequence)String.format("Skip KaiTai generation: Source directory does not exists: %s", this.sourceDirectory.toPath().normalize().toFile().getAbsolutePath()));
            return;
        }
        List<Path> source = KaitaiUtils.scanFiles(this.sourceDirectory.toPath(), this.includes, this.excludes);
        if (source.isEmpty()) {
            this.getLog().warn((CharSequence)String.format("Skip KaiTai generation: Source directory does not contain KaiTai templates (include: %s; exclude: %s): %s", Arrays.toString(this.includes), Arrays.toString(this.excludes), this.sourceDirectory.toPath().normalize().toFile().getAbsolutePath()));
            return;
        }
        StaticLoggerBinder.getSingleton().setMavenLog(this.getLog());
        Logger logger = StaticLoggerBinder.getSingleton().getLoggerFactory().getLogger(((Object)((Object)this)).getClass().getName());
        URL url = KaitaiUtils.prepareUrl(this.url, this.version);
        Path cacheDir = KaitaiUtils.prepareCache(this.detectCacheDir(), logger);
        Path kaitai = KaitaiUtils.downloadKaitai(url, cacheDir, logger);
        Path output = KaitaiUtils.mkdirs(this.output.toPath());
        Path generatedRoot = KaitaiGenerator.generator(kaitai, output, this.packageName).withSource(source).overwrite(this.overwrite).exactOutput(this.exactOutput).executionTimeout(this.executionTimeout).fromFileClass(this.fromFileClass).opaqueTypes(this.opaqueTypes).noVersionCheck(this.noVersionCheck).generate(logger);
        this.project.addCompileSourceRoot(generatedRoot.normalize().toFile().getAbsolutePath());
    }

    private Path detectCacheDir() {
        if (this.cacheDir != null) {
            return this.cacheDir.toPath();
        }
        Path repository = new File(this.session.getLocalRepository().getBasedir()).toPath();
        return repository.resolve(".cache").resolve("kaitai").normalize();
    }
}

