/*
 * Decompiled with CFR 0.152.
 */
package org.josast.inspiresat7;

import io.kaitai.struct.ByteBufferKaitaiStream;
import java.util.logging.Logger;
import org.josast.abstractclass.AFrame;
import org.josast.inspiresat7.AX25decodedData;
import org.josast.inspiresat7.PPrimaryHeader;
import org.josast.inspiresat7.PSecondaryHeader;
import org.josast.inspiresat7.generated.InspireSat7;
import org.josast.inspiresat7.pojogenerated.amsatAscii;
import org.josast.inspiresat7.pojogenerated.antsHk;
import org.josast.inspiresat7.pojogenerated.antsStatus;
import org.josast.inspiresat7.pojogenerated.beacon;
import org.josast.inspiresat7.pojogenerated.iepsHkStatus;
import org.josast.inspiresat7.pojogenerated.imtqHk;
import org.josast.inspiresat7.pojogenerated.iobcHk;
import org.josast.inspiresat7.pojogenerated.iobcStatus;
import org.josast.inspiresat7.pojogenerated.lvStatus;
import org.josast.inspiresat7.pojogenerated.msgOrUnknow;
import org.josast.inspiresat7.pojogenerated.trxvurxHk;
import org.josast.inspiresat7.pojogenerated.trxvutxHk;
import org.josast.telemetry.api.TelemetryAnalysisInterface;
import org.josast.telemetry.api.TelemetryDataInterface;

public class DataAnalysis
implements TelemetryAnalysisInterface {
    private static Logger appLogger = Logger.getLogger("AmsatLogger");
    protected PPrimaryHeader packetPrimaryHeader = null;
    protected PSecondaryHeader packetSecondaryHeader = null;
    protected String separator = "\r\n";
    private int sid;
    protected InspireSat7.UiFrame uiFrame;
    protected AFrame telemetryData;
    protected AX25decodedData ax25;

    public AFrame getTelemetryData() {
        return this.telemetryData;
    }

    public void setUp(InspireSat7 data) {
        try {
            this.uiFrame = (InspireSat7.UiFrame)data.ax25Frame().payload();
            this.ax25 = new AX25decodedData(data);
            this.packetPrimaryHeader = new PPrimaryHeader(this.uiFrame.packetPrimaryHeader());
            this.packetSecondaryHeader = new PSecondaryHeader(this.uiFrame.packetSecondaryHeader());
            this.sid = this.packetSecondaryHeader.getSid();
            this.extractTlm();
        }
        catch (Exception e) {
            appLogger.severe("Error decoding packet " + e.getStackTrace());
        }
    }

    private void extractTlm() {
        switch (this.sid) {
            case 14: {
                this.telemetryData = new amsatAscii((InspireSat7.AmsatAscii)this.uiFrame.tlm());
                break;
            }
            case 15: {
                this.telemetryData = new beacon((InspireSat7.Beacon)this.uiFrame.tlm());
                break;
            }
            case 16: {
                this.telemetryData = new antsHk((InspireSat7.AntsHk)this.uiFrame.tlm());
                break;
            }
            case 17: {
                this.telemetryData = new iobcStatus((InspireSat7.IobcStatus)this.uiFrame.tlm());
                break;
            }
            case 18: {
                this.telemetryData = new iobcHk((InspireSat7.IobcHk)this.uiFrame.tlm());
                break;
            }
            case 19: {
                this.telemetryData = new lvStatus((InspireSat7.LvStatus)this.uiFrame.tlm());
                break;
            }
            case 20: {
                break;
            }
            case 21: {
                this.telemetryData = new iepsHkStatus((InspireSat7.IepsHkStatus)this.uiFrame.tlm());
                break;
            }
            case 22: {
                this.telemetryData = new trxvurxHk((InspireSat7.TrxvurxHk)this.uiFrame.tlm());
                break;
            }
            case 23: {
                this.telemetryData = new imtqHk((InspireSat7.ImtqHk)this.uiFrame.tlm());
                break;
            }
            case 24: {
                this.telemetryData = new trxvutxHk((InspireSat7.TrxvutxHk)this.uiFrame.tlm());
                break;
            }
            case 25: {
                this.telemetryData = new antsStatus((InspireSat7.AntsStatus)this.uiFrame.tlm());
                break;
            }
            default: {
                appLogger.severe("SID not found " + this.sid);
                this.telemetryData = new msgOrUnknow((InspireSat7.MsgOrUnknow)this.uiFrame.tlm());
            }
        }
    }

    public String toString() {
        return this.ax25.toStringHeader() + this.separator + this.packetPrimaryHeader.toString() + this.separator + this.packetSecondaryHeader.toString() + this.separator + this.telemetryData.toStringRaw() + this.separator + this.telemetryData.toStringCompute();
    }

    public String toStringFormat() {
        return "###############################################################" + this.separator + "AX25 HEADER" + this.separator + this.ax25.toStringHeader() + "===============================================================" + this.separator + "HEADERS" + this.separator + "===============================================================" + this.separator + this.packetPrimaryHeader.toString() + this.separator + this.packetSecondaryHeader.toString() + this.separator + this.separator + "===============================================================" + this.separator + "COMPUTE DATA" + this.separator + this.telemetryData.toStringCompute() + this.separator + "###############################################################" + this.separator;
    }

    public int getSid() {
        return this.sid;
    }

    public void setSid(int sid) {
        this.sid = sid;
    }

    public PPrimaryHeader getPacketPrimaryHeader() {
        return this.packetPrimaryHeader;
    }

    public PSecondaryHeader getPacketSecondaryHeader() {
        return this.packetSecondaryHeader;
    }

    public InspireSat7.UiFrame getUiFrame() {
        return this.uiFrame;
    }

    @Override
    public TelemetryDataInterface analyse(byte[] data) {
        try {
            InspireSat7 cube = new InspireSat7(new ByteBufferKaitaiStream(data));
            this.setUp(cube);
        }
        catch (Exception e) {
            System.out.println("Error " + e.getMessage());
        }
        return this.telemetryData;
    }

    @Override
    public String getSatelliteName() {
        return "InspireSat 7";
    }
}

