/*
 * Decompiled with CFR 0.152.
 */
package org.josast.ModuleSoundModem;

import java.util.Arrays;
import org.josast.ModuleSoundModem.KissException;

public class Kiss {
    private static final byte DATA = 0;
    private static final byte UNKNOW = -16;
    private static final byte TXDELAY = 1;
    private static final byte P = 2;
    private static final byte SLOTTIME = 3;
    private static final byte TXTAIL = 4;
    private static final byte FULLDUPLEX = 5;
    private static final byte SETHARDWARE = 6;
    private static final byte RETURN = -1;
    public static final byte FEND = -64;
    public static final byte FESC = -37;
    public static final byte TFEND = -36;
    public static final byte TFESC = -35;
    byte[] kissdata = null;
    byte type = 0;

    public Kiss(byte[] data) {
        this.kissdata = (byte[])data.clone();
    }

    public byte getType() {
        return this.type;
    }

    public void setType(byte type) {
        this.type = type;
    }

    public byte[] toRaw() throws KissException {
        byte[] rawData = null;
        rawData = new byte[this.kissdata.length];
        if (this.kissdata[0] != -64) {
            throw new KissException("FEND (0xC0)  value not find at the beginning of the frame ");
        }
        if (this.kissdata[this.kissdata.length - 1] != -64) {
            throw new KissException("FEND (0xC0)  value not find at the end of the frame ");
        }
        switch (this.kissdata[1]) {
            case 0: {
                this.type = 0;
                break;
            }
            case 1: {
                this.type = 1;
                break;
            }
            case 2: {
                this.type = (byte)2;
                break;
            }
            case 3: {
                this.type = (byte)3;
                break;
            }
            case 4: {
                this.type = (byte)4;
                break;
            }
            case 5: {
                this.type = (byte)5;
                break;
            }
            case 6: {
                this.type = (byte)6;
                break;
            }
            case -1: {
                this.type = (byte)-1;
                break;
            }
            default: {
                this.type = (byte)-16;
            }
        }
        int cptraw = 0;
        int i = 2;
        while (this.kissdata[i] != -64) {
            if (this.kissdata[i] != -37) {
                rawData[cptraw++] = this.kissdata[i++];
                continue;
            }
            if (this.kissdata[i + 1] == -36) {
                rawData[cptraw++] = -64;
                i += 2;
                continue;
            }
            if (this.kissdata[i + 1] == -35) {
                rawData[cptraw++] = -37;
                i += 2;
                continue;
            }
            rawData[cptraw++] = this.kissdata[i++];
        }
        return Arrays.copyOf(rawData, cptraw);
    }
}

