/*
 * Decompiled with CFR 0.152.
 */
package org.josast.ApplicationKissTool;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import org.josast.ApplicationKissTool.SatelliteNorad;

public class SatelliteNoradFile {
    private static Logger appLogger = Logger.getLogger("AmsatLogger");
    private List<SatelliteNorad> SatelliteNoradList;
    private Hashtable<String, SatelliteNorad> htsatNorad = new Hashtable();

    public List<SatelliteNorad> getSatelliteNoradList() {
        return new ArrayList<SatelliteNorad>(this.SatelliteNoradList);
    }

    private String getFileName(String file) {
        boolean res;
        String path = System.getProperty("user.dir") + "/config";
        File apath = new File(path);
        if (!apath.exists() && !(res = apath.mkdir())) {
            appLogger.severe("fail to create " + path);
        }
        return path + "/" + file;
    }

    public void writeFile(String file) {
        try {
            FileWriter writer = new FileWriter(this.getFileName(file), Charset.forName("utf-8"));
            new Gson().toJson(this.SatelliteNoradList, (Appendable)writer);
            ((Writer)writer).close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void readFile(String file) {
        try {
            BufferedReader reader = Files.newBufferedReader(Paths.get(this.getFileName(file), new String[0]));
            this.SatelliteNoradList = (List)new Gson().fromJson((Reader)reader, new TypeToken<List<SatelliteNorad>>(){}.getType());
            Iterator<SatelliteNorad> it = this.SatelliteNoradList.iterator();
            appLogger.info("nb sat" + this.SatelliteNoradList.size());
            while (it.hasNext()) {
                SatelliteNorad sat = it.next();
                this.htsatNorad.put(sat.getCallsign(), sat);
            }
            this.SatelliteNoradList.forEach(System.out::println);
            ((Reader)reader).close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public int getNorad(String callsign2) {
        int norad = 0;
        SatelliteNorad sat = this.htsatNorad.get(callsign2);
        if (sat != null) {
            norad = sat.getNoradId();
        }
        return norad;
    }

    public String getName(String callsign2) {
        String name = null;
        SatelliteNorad sat = this.htsatNorad.get(callsign2);
        if (sat != null) {
            name = sat.getName();
        }
        return name;
    }

    public void initialise() {
        this.SatelliteNoradList = Arrays.asList(new SatelliteNorad("UVSQsat", 47438, "LATMOS"), new SatelliteNorad("Defaut", 99999, null), new SatelliteNorad("Picsat", 43132, "PICSAT"));
    }

    public static void main(String[] args) {
        SatelliteNoradFile s = new SatelliteNoradFile();
        s.readFile("SatelliteNoradList.json");
    }
}

