/*
 * Decompiled with CFR 0.152.
 */
package org.josast.ApplicationKissTool;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.josast.ApplicationKissTool.TlmData;
import org.json.JSONObject;

public class ManageDataFile {
    private static Logger appLogger = Logger.getLogger("AmsatLogger");
    private String generateRepository = "./ouputFile";
    private int cpt = 0;
    private Path filepath;
    private String RepositoryPath = null;

    public ManageDataFile() {
        this.initDirectory();
    }

    public void saveRawFile(byte[] data) {
        Object message = "File created ";
        try {
            Files.write(Paths.get(this.RepositoryPath + "\\Frame_" + this.cpt++ + ".bin", new String[0]), data, new OpenOption[0]);
        }
        catch (IOException e) {
            message = "Error creation file : " + e.toString();
            appLogger.severe((String)message);
        }
    }

    public void saveDataHex(String stringData) {
        SimpleDateFormat formater = new SimpleDateFormat("yyyy-MM-dd-HH");
        Date aujourdhui = new Date();
        String creationdate = formater.format(aujourdhui);
        this.filepath = Paths.get(this.RepositoryPath + "\\" + creationdate + "-Data-hex.txt", new String[0]);
        try {
            if (!Files.exists(this.filepath, new LinkOption[0])) {
                Files.createFile(this.filepath, new FileAttribute[0]);
            }
            Files.writeString(this.filepath, (CharSequence)(stringData + "\r\n"), StandardOpenOption.APPEND);
        }
        catch (IOException e) {
            appLogger.severe(e.toString());
        }
    }

    public int saveTlmData(TlmData tlmData) {
        int erreur = 0;
        SimpleDateFormat formater = new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss.SSS");
        Date aujourdhui = new Date();
        JSONObject jasonObject = new JSONObject(tlmData);
        String creationdate = formater.format(aujourdhui);
        this.filepath = Paths.get(this.RepositoryPath + "\\" + creationdate + "-Data.json", new String[0]);
        try {
            Files.createFile(this.filepath, new FileAttribute[0]);
            Files.writeString(this.filepath, (CharSequence)(jasonObject.toString() + "\r\n"), StandardOpenOption.CREATE);
            if (Files.size(this.filepath) < 10L) {
                appLogger.severe("file not created ");
                erreur = -1;
            }
        }
        catch (IOException e) {
            appLogger.severe(e.toString());
            erreur = -1;
        }
        return erreur;
    }

    public void initDirectory() {
        if (this.RepositoryPath == null) {
            this.RepositoryPath = System.getProperty("user.dir") + "\\data";
        } else if (this.RepositoryPath.length() == 0) {
            this.RepositoryPath = System.getProperty("user.dir") + "\\data";
        }
        Path path = Paths.get(this.RepositoryPath, new String[0]);
        if (!Files.exists(path, new LinkOption[0])) {
            try {
                Files.createDirectories(path, new FileAttribute[0]);
                appLogger.info("directory created : " + this.RepositoryPath);
            }
            catch (IOException e) {
                appLogger.log(Level.SEVERE, "cannot create outpout directorie " + e.toString());
            }
        }
        if (!Files.exists(path = Paths.get(this.generateRepository, new String[0]), new LinkOption[0])) {
            try {
                Files.createDirectories(path, new FileAttribute[0]);
                appLogger.info("directory created : " + this.RepositoryPath);
            }
            catch (IOException e) {
                appLogger.log(Level.SEVERE, "cannot create outpout directorie " + e.toString());
            }
        }
    }

    public String getRepositoryPath() {
        return this.RepositoryPath;
    }

    public void setRepositoryPath(String repositoryPath) {
        this.RepositoryPath = repositoryPath;
        this.initDirectory();
    }
}

