/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.util;

import java.io.PrintWriter;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import org.castor.core.util.Messages;
import org.exolab.castor.util.CmdLineOption;

public class CommandLineOptions {
    private final Vector<String> _flags = new Vector();
    private final Hashtable<String, CmdLineOption> _optionInfo = new Hashtable();
    private final PrintWriter _errorWriter = new PrintWriter(System.out);

    public void addFlag(String flag) {
        this.addFlag(flag, null, null);
    }

    public void addFlag(String flag, String comment) {
        this.addFlag(flag, null, comment, false);
    }

    public void addFlag(String flag, String usageText, String comment) {
        this.addFlag(flag, usageText, comment, false);
    }

    public void addFlag(String flag, String usageText, String comment, boolean optional) {
        if (flag == null) {
            return;
        }
        this._flags.add(flag);
        CmdLineOption opt = new CmdLineOption(flag);
        opt.setComment(comment);
        opt.setUsageText(usageText);
        opt.setOptional(optional);
        this._optionInfo.put(flag, opt);
    }

    public Properties getOptions(String[] args) {
        Properties options = new Properties();
        String flag = null;
        block0: for (int i = 0; i < args.length; ++i) {
            if (args[i].startsWith("-")) {
                if (flag != null) {
                    options.put(flag, args[i]);
                    options.put((Object)i, args[i]);
                }
                if (this._flags.contains(flag = args[i].substring(1))) continue;
                for (int idx = 1; idx <= flag.length(); ++idx) {
                    if (this._flags.contains(flag.substring(0, idx))) {
                        if (idx >= flag.length()) continue;
                        options.put(flag.substring(0, idx), flag.substring(idx));
                        continue block0;
                    }
                    if (idx != flag.length()) continue;
                    this._errorWriter.println(Messages.format("misc.invalidCLIOption", "-" + flag));
                    this.printUsage(this._errorWriter);
                }
                continue;
            }
            if (flag != null) {
                options.put(flag, args[i]);
            }
            options.put((Object)i, args[i]);
            flag = null;
        }
        if (flag != null) {
            options.put(flag, "no value");
        }
        return options;
    }

    public void setComment(String flag, String comment) {
        if (flag == null) {
            return;
        }
        CmdLineOption opt = this._optionInfo.get(flag);
        if (opt != null) {
            opt.setComment(comment);
        }
    }

    public void setOptional(String flag, boolean optional) {
        if (flag == null) {
            return;
        }
        CmdLineOption opt = this._optionInfo.get(flag);
        if (opt != null) {
            opt.setOptional(optional);
        }
    }

    public void setUsageInfo(String flag, String usage) {
        if (flag == null) {
            return;
        }
        CmdLineOption opt = this._optionInfo.get(flag);
        if (opt != null) {
            opt.setUsageText(usage);
        }
    }

    public void printUsage(PrintWriter pw) {
        pw.println();
        pw.print(Messages.message("misc.CLIUsage"));
        for (int i = 0; i < this._flags.size(); ++i) {
            String flag = this._flags.elementAt(i);
            CmdLineOption opt = this._optionInfo.get(flag);
            if (opt.getOptional()) {
                pw.print(" [-");
            } else {
                pw.print(" -");
            }
            pw.print(flag);
            String usage = opt.getUsageText();
            if (usage != null) {
                pw.print(' ');
                pw.print(usage);
            }
            if (!opt.getOptional()) continue;
            pw.print(']');
        }
        pw.println();
        pw.flush();
    }

    public void printHelp(PrintWriter pw) {
        this.printUsage(pw);
        pw.println();
        if (!this._flags.isEmpty()) {
            pw.println("Flag               Description");
            pw.println("----------------------------------------------");
        }
        for (String flag : this._flags) {
            CmdLineOption opt = this._optionInfo.get(flag);
            pw.print('-');
            pw.print(flag);
            pw.print(' ');
            for (int spaces = 17 - flag.length(); spaces > 0; --spaces) {
                pw.print(' ');
            }
            pw.print(opt.getComment());
            pw.println();
        }
        pw.println();
        pw.flush();
    }
}

