/*
 * Decompiled with CFR 0.152.
 */
package name.valery1707.kaitai;

import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import name.valery1707.kaitai.KaitaiException;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.WildcardFileFilter;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.slf4j.Logger;

public final class KaitaiUtils {
    private static final String URL_FORMAT = "https://dl.bintray.com/kaitai-io/universal/%s/kaitai-struct-compiler-%s.zip";
    private static final String KAITAI_START_SCRIPT = "kaitai-struct-compiler.bat";
    private static final Map<Boolean, String> SCRIPT_SUFFIX_REMOVER = Collections.unmodifiableMap(new HashMap<Boolean, String>(){
        {
            this.put(true, "");
            this.put(false, ".bat");
        }
    });

    private KaitaiUtils() {
    }

    public static void checkFileIsReadable(Path target) throws KaitaiException {
        if (!Files.isRegularFile(target, new LinkOption[0]) || !Files.isReadable(target)) {
            throw new KaitaiException(String.format("Fail to read file: %s", target.normalize().toFile().getAbsolutePath()));
        }
    }

    public static void checkFileIsExecutable(Path target) throws KaitaiException {
        KaitaiUtils.checkFileIsReadable(target);
        if (!Files.isExecutable(target)) {
            try {
                HashSet<PosixFilePermission> perms = new HashSet<PosixFilePermission>(Files.getPosixFilePermissions(target, LinkOption.NOFOLLOW_LINKS));
                perms.add(PosixFilePermission.OWNER_EXECUTE);
                Files.setPosixFilePermissions(target, perms);
            }
            catch (IOException e) {
                throw new KaitaiException(String.format("Fail to set executable flag to file: %s", target.normalize().toFile().getAbsolutePath()));
            }
        }
        if (!Files.isExecutable(target)) {
            throw new KaitaiException(String.format("Fail to execute file: %s", target.normalize().toFile().getAbsolutePath()));
        }
    }

    public static void checkDirectoryIsReadable(Path target) throws KaitaiException {
        if (!Files.isDirectory(target, new LinkOption[0]) || !Files.isReadable(target)) {
            throw new KaitaiException(String.format("Fail to read from directory: %s", target.normalize().toFile().getAbsolutePath()));
        }
    }

    public static List<Path> scanFiles(Path root, String[] includes, String[] excludes) throws KaitaiException {
        KaitaiUtils.checkDirectoryIsReadable(root);
        IOFileFilter filter = FileFilterUtils.and(new WildcardFileFilter(includes), FileFilterUtils.notFileFilter(new WildcardFileFilter(excludes)));
        try {
            ArrayList<Path> list = new ArrayList<Path>();
            Files.walkFileTree(root.normalize(), new FilterFileVisitor(filter, list));
            return list;
        }
        catch (IOException e) {
            throw new KaitaiException(String.format("Fail to scan directory: %s", root.normalize().toFile().getAbsolutePath()), e);
        }
    }

    public static void checkDirectoryIsWritable(Path target) throws KaitaiException {
        if (!Files.isDirectory(target, new LinkOption[0]) || !Files.isWritable(target)) {
            throw new KaitaiException(String.format("Fail to write into directory: %s", target.normalize().toFile().getAbsolutePath()));
        }
    }

    public static Path mkdirs(Path target) throws KaitaiException {
        if (!Files.exists(target = target.normalize(), new LinkOption[0])) {
            try {
                Files.createDirectories(target, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new KaitaiException(String.format("Fail to create directory: %s", target.normalize().toFile().getAbsolutePath()), e);
            }
        }
        KaitaiUtils.checkDirectoryIsWritable(target);
        return target;
    }

    public static Path createTempDirectory(String prefix, FileAttribute<?> ... attributes) throws KaitaiException {
        try {
            return Files.createTempDirectory(prefix, attributes);
        }
        catch (IOException e) {
            throw new KaitaiException("Fail to create temp directory", e);
        }
    }

    public static void delete(Path path) throws KaitaiException {
        if (!Files.exists(path, new LinkOption[0])) {
            return;
        }
        try {
            if (Files.isRegularFile(path, new LinkOption[0])) {
                Files.delete(path);
            } else if (Files.isDirectory(path, new LinkOption[0])) {
                Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                        Files.delete(file);
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                        if (exc != null) {
                            throw exc;
                        }
                        Files.delete(dir);
                        return FileVisitResult.CONTINUE;
                    }
                });
            }
        }
        catch (IOException e) {
            throw new KaitaiException(String.format("Fail to delete: %s", path.normalize().toAbsolutePath()), e);
        }
    }

    public static void move(Path source, Path target) throws KaitaiException {
        try {
            Files.move(source, target, StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            throw new KaitaiException(String.format("Fail to move '%s' into '%s'", source.normalize().toAbsolutePath(), target.normalize().toAbsolutePath()), e);
        }
    }

    public static void move(Path sourceRoot, Collection<Path> items, Path targetRoot) throws KaitaiException {
        sourceRoot = sourceRoot.toAbsolutePath().normalize();
        for (Path source : items) {
            Path target = targetRoot.resolve(sourceRoot.relativize(source));
            KaitaiUtils.mkdirs(target.getParent());
            if (Files.isRegularFile(source, new LinkOption[0])) {
                KaitaiUtils.move(source, target);
                continue;
            }
            KaitaiUtils.mkdirs(target);
        }
    }

    public static void download(URL source, Path target, Logger log) throws KaitaiException {
        if (Files.exists(target, new LinkOption[0])) {
            return;
        }
        Path temp = target.resolveSibling(target.getFileName().toString() + ".tmp");
        KaitaiUtils.delete(temp);
        log.info(String.format("KaiTai distribution: Downloading: %s", source));
        try (InputStream is = source.openStream();
             OutputStream os = Files.newOutputStream(temp, StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);){
            IOUtils.copy(is, os);
        }
        catch (IOException e) {
            throw new KaitaiException(String.format("Fail to download '%s' into '%s'", source, temp.normalize().toFile().getAbsolutePath()), e);
        }
        KaitaiUtils.move(temp, target);
    }

    public static Path unpack(Path zip, Logger log) throws KaitaiException {
        String filename = zip.getFileName().toString();
        String extension = FilenameUtils.getExtension(filename);
        Path dir = zip.resolveSibling(filename.replace("." + extension, ""));
        if (Files.isDirectory(dir, new LinkOption[0])) {
            return dir;
        }
        log.info(String.format("KaiTai distribution: Extracting: %s", zip.normalize().toFile().getAbsolutePath()));
        Path temp = dir.resolveSibling(dir.getFileName().toString() + "-tmp");
        KaitaiUtils.delete(temp);
        try (InputStream is = Files.newInputStream(zip, new OpenOption[0]);
             ZipInputStream zis = new ZipInputStream(is);){
            ZipEntry entry;
            Files.createDirectory(temp, new FileAttribute[0]);
            while ((entry = zis.getNextEntry()) != null) {
                if (entry.isDirectory()) continue;
                Path current = temp.resolve(StringUtils.removeStart(entry.getName(), "/"));
                Files.createDirectories(current.getParent(), new FileAttribute[0]);
                Files.copy(zis, current, StandardCopyOption.REPLACE_EXISTING);
            }
        }
        catch (IOException e) {
            throw new KaitaiException(String.format("Fail to extract content of '%s'", zip.normalize().toFile().getAbsolutePath()), e);
        }
        KaitaiUtils.move(temp, dir);
        return dir;
    }

    public static URL prepareUrl(URL url, String version) throws KaitaiException {
        if (url == null) {
            try {
                return new URL(String.format(URL_FORMAT, version, version));
            }
            catch (MalformedURLException e) {
                throw new KaitaiException("Invalid version: " + version, e);
            }
        }
        return url;
    }

    public static Path prepareCache(Path cache, Logger log) throws KaitaiException {
        log.debug(String.format("KaiTai distribution: Prepare cache directory: %s", cache.normalize().toFile().getAbsolutePath()));
        return KaitaiUtils.mkdirs(cache);
    }

    public static Path downloadKaitai(URL url, Path cacheDir, Logger log) throws KaitaiException {
        Path distZip = cacheDir.resolve(FilenameUtils.getName(url.getFile()));
        KaitaiUtils.download(url, distZip, log);
        Path dist = KaitaiUtils.unpack(distZip, log);
        List<Path> bats = KaitaiUtils.scanFiles(dist, new String[]{KAITAI_START_SCRIPT}, new String[0]);
        if (bats.size() != 1) {
            throw new KaitaiException(String.format("Fail to find start script '%s' in Kaitai distribution: %s", KAITAI_START_SCRIPT, dist.normalize().toFile().getAbsolutePath()));
        }
        Path bat = bats.get(0);
        String suffixToRemove = SCRIPT_SUFFIX_REMOVER.get(SystemUtils.IS_OS_WINDOWS);
        return bat.resolveSibling(bat.getFileName().toString().replace(suffixToRemove, ""));
    }

    private static class FilterFileVisitor
    extends SimpleFileVisitor<Path> {
        private final FilenameFilter filter;
        private final List<Path> target;

        private FilterFileVisitor(FilenameFilter filter, List<Path> target) {
            this.filter = filter;
            this.target = target;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
            if (this.filter.accept(null, file.getFileName().toString())) {
                this.target.add(file.normalize().toAbsolutePath());
            }
            return FileVisitResult.CONTINUE;
        }
    }
}

