/*
 * Decompiled with CFR 0.152.
 */
package org.josast.ModuleSoundModem;

import java.util.logging.Logger;
import org.josast.property.ConfigObject;

public class SoundModemConfiguration
extends ConfigObject {
    private Logger log = Logger.getLogger("AmsatLogger");
    private String smIPadress = "localhost";
    private int smPort = 8100;
    private boolean smGenerateBinarieFile = false;
    private String smBinarieOutputFile = "soundmodem.bin";
    private String smBinarieOutputDirectory = "SoundModemOuput";
    private boolean smBinarieFilePrefixDate = false;

    public SoundModemConfiguration(String configFilename) {
        super(configFilename);
        String temp = this.configFile.getProperty("smPort");
        if (temp == null) {
            this.initialisePropertiesFile();
            this.log.severe("properties file not initialised - a file is created with properties with defaults value");
            System.out.println("config file does not content required properties \n the file " + configFilename + " has been set up with properties to configure");
        } else {
            this.initialiseFromProperties();
        }
    }

    private void initialisePropertiesFile() {
        this.configFile.setProperty("smIPadress", this.smIPadress);
        this.configFile.setProperty("smPort", "" + this.smPort);
        this.configFile.setProperty("smGenerateBinarieFile", "" + this.smGenerateBinarieFile);
        this.configFile.setProperty("smBinarieOutputFile", this.smBinarieOutputFile);
        this.configFile.setProperty("smBinarieOutputFile", this.smBinarieOutputDirectory);
        this.configFile.setProperty("smBinarieFilePrefixDate", "" + this.smBinarieFilePrefixDate);
    }

    private void initialiseFromProperties() {
        this.smIPadress = this.configFile.getProperty("smIPadress");
        this.smPort = Integer.parseInt(this.configFile.getProperty("smPort"));
        this.smGenerateBinarieFile = Boolean.parseBoolean(this.configFile.getProperty("smGenerateBinarieFile"));
        this.smBinarieOutputFile = this.configFile.getProperty("smBinarieOutputFile");
        this.smBinarieOutputDirectory = this.configFile.getProperty("smBinarieOutputDirectory");
        this.smBinarieFilePrefixDate = Boolean.parseBoolean(this.configFile.getProperty("smBinarieFilePrefixDate"));
    }

    public String getSmIPadress() {
        return this.smIPadress;
    }

    public void setSmIPadress(String iPadress) {
        this.smIPadress = iPadress;
    }

    public int getSmPort() {
        return this.smPort;
    }

    public void setSmPort(int port) {
        this.smPort = port;
    }

    public String toString() {
        return this.smIPadress + ":" + this.smPort;
    }

    public boolean isSmGenerateBinarieFile() {
        return this.smGenerateBinarieFile;
    }

    public void setSmGenerateBinarieFile(boolean smGenerateBinarieFile) {
        this.smGenerateBinarieFile = smGenerateBinarieFile;
    }

    public String getSmBinarieOutputFile() {
        return this.smBinarieOutputFile;
    }

    public void setSmBinarieOutputFile(String smBinarieOutputFile) {
        this.smBinarieOutputFile = smBinarieOutputFile;
    }

    public boolean isSmBinarieFilePrefixDate() {
        return this.smBinarieFilePrefixDate;
    }

    public void setSmBinarieFilePrefixDate(boolean smBinarieFilePrefixDate) {
        this.smBinarieFilePrefixDate = smBinarieFilePrefixDate;
    }

    public String getSmBinarieOutputDirectory() {
        return this.smBinarieOutputDirectory;
    }

    public void setSmBinarieOutputDirectory(String smBinarieOutputDirectory) {
        this.smBinarieOutputDirectory = smBinarieOutputDirectory;
    }
}

