/*
 * Decompiled with CFR 0.152.
 */
package org.josast.ApplicationKissTool;

import java.util.Date;
import java.util.concurrent.BlockingQueue;
import java.util.logging.Logger;
import javafx.application.Platform;
import javafx.concurrent.Task;
import org.josast.ApplicationKissTool.Controler;
import org.josast.ApplicationKissTool.ReceivedData;
import org.josast.ModuleSoundModem.SoundModemClient;
import org.josast.ModuleSoundModem.SoundModemConfiguration;

public class TaskSoundmodemTCP
extends Task<String> {
    private Logger log = Logger.getLogger("AmsatLogger");
    private volatile boolean running = true;
    SoundModemConfiguration smConfiguration = null;
    SoundModemClient smc = null;
    Controler ctrl = null;
    BlockingQueue<ReceivedData> blockingQueue = null;

    public TaskSoundmodemTCP(SoundModemConfiguration smConfiguration2, BlockingQueue<ReceivedData> blockingQueueIn, Controler ctrlIn) {
        this.smConfiguration = smConfiguration2;
        this.blockingQueue = blockingQueueIn;
        this.smc = new SoundModemClient(smConfiguration2);
        this.ctrl = ctrlIn;
        if (!this.smc.isOpen()) {
            this.failed();
        } else {
            this.succeeded();
        }
    }

    public TaskSoundmodemTCP(SoundModemConfiguration smConfiguration2, BlockingQueue<ReceivedData> blockingQueueIn) {
        this.smConfiguration = smConfiguration2;
        this.blockingQueue = blockingQueueIn;
        this.smc = new SoundModemClient(smConfiguration2);
        if (!this.smc.isOpen()) {
            this.failed();
        } else {
            this.succeeded();
        }
    }

    public TaskSoundmodemTCP(BlockingQueue<ReceivedData> blockingQueueIn) {
        this.smConfiguration = new SoundModemConfiguration("default");
        this.blockingQueue = blockingQueueIn;
        this.smc = new SoundModemClient(this.smConfiguration);
        if (!this.smc.isOpen()) {
            this.failed();
        } else {
            this.succeeded();
        }
    }

    private void updatenbFrame() {
        Platform.runLater(new Runnable(){

            @Override
            public void run() {
                try {
                    TaskSoundmodemTCP.this.ctrl.IncrementNbFrame();
                }
                catch (Exception e) {
                    TaskSoundmodemTCP.this.ctrl.displayLog("Update frame Run - error");
                    e.printStackTrace();
                }
            }
        });
    }

    @Override
    protected String call() {
        try {
            while (this.running) {
                if (this.smc.isOpen()) {
                    byte[] temp = this.smc.receivedRawData();
                    this.blockingQueue.add(new ReceivedData(new Date(), temp));
                    this.updatenbFrame();
                    continue;
                }
                this.running = false;
                this.ctrl.displayLog("Erreur SoundModem closed");
                this.log.severe("Erreur SoundModem closed");
            }
        }
        catch (Exception e) {
            this.log.severe("Erreur SoundModem not available");
            this.log.severe(e.toString());
            this.ctrl.displayLog("Erreur SoundModem not available");
            this.failed();
        }
        this.log.severe("End call available");
        this.ctrl.displayLog("End call available");
        return "C";
    }

    public void arreter() {
        this.running = false;
        this.smc.close();
    }

    public void redemarrer() {
        this.log.severe("REDEMARAGE");
        if (!this.smc.isOpen()) {
            this.failed();
        } else {
            this.succeeded();
            this.running = true;
        }
        this.call();
    }
}

