/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.xml;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exolab.castor.xml.Namespaces;
import org.xml.sax.helpers.AttributeListImpl;

public class NamespacesStack {
    private final Log logger = LogFactory.getLog(this.getClass());
    private static final String DEFAULT_NAMESPACE = "";
    private List<Namespaces> namespaceStack = new ArrayList<Namespaces>();

    public void addNamespace(String namespacePrefix, String namespaceUri) {
        Namespaces namespaces = this.getCurrentNamespaceScope();
        if (namespaces != null) {
            namespaces.addNamespace(namespacePrefix, namespaceUri);
        }
    }

    public void addDefaultNamespace(String namespaceUri) {
        this.addNamespace(DEFAULT_NAMESPACE, namespaceUri);
    }

    public void removeNamespace(String namespacePrefix) {
        this.getCurrentNamespaceScope().removeNamespace(namespacePrefix);
    }

    public String getNamespaceURI(String namespacePrefix) {
        String namespaceUri = null;
        for (int ind = this.namespaceStack.size() - 1; ind >= 0 && namespaceUri == null; --ind) {
            namespaceUri = this.namespaceStack.get(ind).getNamespaceURI(namespacePrefix);
        }
        return namespaceUri;
    }

    public void declareAsAttributes(AttributeListImpl attributeList, boolean localOnly) {
        this.getCurrentNamespaceScope().declareAsAttributes(attributeList);
        if (!localOnly) {
            for (int ind = this.namespaceStack.size() - 1; ind >= 0; --ind) {
                this.namespaceStack.get(ind).declareAsAttributes(attributeList);
            }
        }
    }

    public String getDefaultNamespaceURI() {
        return this.getNamespaceURI(DEFAULT_NAMESPACE);
    }

    public String getNamespacePrefix(String namespaceUri) {
        String namespacePrefix = null;
        for (int ind = this.namespaceStack.size() - 1; ind >= 0 && namespacePrefix == null; --ind) {
            namespacePrefix = this.namespaceStack.get(ind).getNamespacePrefix(namespaceUri);
        }
        return namespacePrefix;
    }

    public String getNonDefaultNamespacePrefix(String namespaceUri) {
        String namespacePrefix = null;
        for (int ind = this.namespaceStack.size() - 1; ind >= 0 && namespacePrefix == null; --ind) {
            namespacePrefix = this.namespaceStack.get(ind).getNonDefaultNamespacePrefix(namespaceUri);
        }
        return namespacePrefix;
    }

    public Enumeration<String> getLocalNamespacePrefixes() {
        Namespaces namespaces = this.getCurrentNamespaceScope();
        return namespaces != null ? namespaces.getLocalNamespacePrefixes() : null;
    }

    public void addNewNamespaceScope() {
        this.namespaceStack.add(new Namespaces());
    }

    public void removeNamespaceScope() {
        if (!this.namespaceStack.isEmpty()) {
            this.namespaceStack.remove(this.namespaceStack.size() - 1);
        } else {
            this.logger.error("Trying to remove a namespaces scope from an empty stack of Namespaces");
        }
    }

    public Namespaces getCurrentNamespaceScope() {
        if (this.namespaceStack.isEmpty()) {
            this.addNewNamespaceScope();
        }
        return this.namespaceStack.get(this.namespaceStack.size() - 1);
    }
}

