/*
 * Decompiled with CFR 0.152.
 */
package org.buildobjects.process;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.buildobjects.process.OutputConsumptionThread;
import org.buildobjects.process.StreamCopyRunner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class IoHandler {
    private final OutputConsumptionThread stdout;
    private final OutputConsumptionThread stderr;
    Thread inFeeder;

    IoHandler(InputStream stdin, OutputConsumptionThread stdout, OutputConsumptionThread stderr, Process process) {
        this.stdout = stdout;
        this.stderr = stderr;
        InputStream out = process.getInputStream();
        InputStream err = process.getErrorStream();
        OutputStream in = process.getOutputStream();
        stdout.startConsumption(out);
        stderr.startConsumption(err);
        this.inFeeder = this.startConsumption(in, stdin, true);
    }

    List<Throwable> joinConsumption() throws InterruptedException {
        this.inFeeder.join();
        this.stdout.join();
        this.stderr.join();
        ArrayList<Throwable> exceptions = new ArrayList<Throwable>();
        if (this.stdout.getThrowable() != null) {
            exceptions.add(this.stdout.getThrowable());
        }
        if (this.stderr.getThrowable() != null) {
            exceptions.add(this.stderr.getThrowable());
        }
        return exceptions;
    }

    void cancelConsumption() {
        this.inFeeder.interrupt();
        this.stdout.interrupt();
        this.stderr.interrupt();
    }

    Thread startConsumption(OutputStream stdout, InputStream out, boolean closeAfterWriting) {
        Thread consumer = new Thread(new StreamCopyRunner(out, stdout, closeAfterWriting));
        consumer.start();
        return consumer;
    }
}

