/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.client;

import java.util.Locale;
import org.apache.http.auth.AuthSchemeProvider;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.impl.auth.BasicSchemeFactory;
import org.apache.http.impl.auth.DigestSchemeFactory;
import org.apache.http.impl.auth.win.WindowsCredentialsProvider;
import org.apache.http.impl.auth.win.WindowsNTLMSchemeFactory;
import org.apache.http.impl.auth.win.WindowsNegotiateSchemeFactory;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.SystemDefaultCredentialsProvider;

public class WinHttpClients {
    private WinHttpClients() {
    }

    public static boolean isWinAuthAvailable() {
        String os = System.getProperty("os.name");
        String string = os = os != null ? os.toLowerCase(Locale.ROOT) : null;
        if (os != null && os.contains("windows")) {
            try {
                return true;
            }
            catch (Exception ignore) {
                return false;
            }
        }
        return false;
    }

    private static HttpClientBuilder createBuilder() {
        if (WinHttpClients.isWinAuthAvailable()) {
            Registry<AuthSchemeProvider> authSchemeRegistry = RegistryBuilder.create().register("Basic", new BasicSchemeFactory()).register("Digest", (BasicSchemeFactory)((Object)new DigestSchemeFactory())).register("NTLM", (BasicSchemeFactory)((Object)new WindowsNTLMSchemeFactory(null))).register("Negotiate", (BasicSchemeFactory)((Object)new WindowsNegotiateSchemeFactory(null))).build();
            WindowsCredentialsProvider credsProvider = new WindowsCredentialsProvider(new SystemDefaultCredentialsProvider());
            return HttpClientBuilder.create().setDefaultCredentialsProvider(credsProvider).setDefaultAuthSchemeRegistry(authSchemeRegistry);
        }
        return HttpClientBuilder.create();
    }

    public static HttpClientBuilder custom() {
        return WinHttpClients.createBuilder();
    }

    public static CloseableHttpClient createDefault() {
        return WinHttpClients.createBuilder().build();
    }

    public static CloseableHttpClient createSystem() {
        return WinHttpClients.createBuilder().useSystemProperties().build();
    }
}

