/*
 * Decompiled with CFR 0.152.
 */
package org.josast.ModuleSoundModem;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.logging.Logger;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.josast.ModuleSoundModem.SoundModemClient;

public class SoundModemCli {
    private Logger log = Logger.getLogger("AmsatLogger");
    private static String version = "0.2";
    private String configurationfile = "defaultConfigFile.ini";
    private String generateRepository = "SoundModemOuput";

    public String getConfigurationfile() {
        return this.configurationfile;
    }

    public void setConfigurationfile(String configurationfile) {
        this.configurationfile = configurationfile;
    }

    public String getGenerateRepository() {
        return this.generateRepository;
    }

    public void setGenerateRepository(String generateRepository) {
        this.generateRepository = generateRepository;
    }

    private static Options configParameters() {
        Option versionOption = Option.builder("V").longOpt("Version").desc("Return application version").hasArg(false).required(false).build();
        Option configFileOption = Option.builder("C").longOpt("Config").desc("Return application version").hasArg(true).argName("configFile").required(false).build();
        Option generateFileOption = Option.builder("G").longOpt("Generate").desc("generate binary file for each frame received").hasArg(true).argName("GenerateRepository").required(false).build();
        Option helpFileOption = Option.builder("h").longOpt("help").desc("display help message").build();
        Options options = new Options();
        options.addOption(versionOption);
        options.addOption(configFileOption);
        options.addOption(generateFileOption);
        options.addOption(helpFileOption);
        return options;
    }

    public void execute() {
        SoundModemClient sm = new SoundModemClient(this.configurationfile);
        int cpt = 0;
        Path path = Paths.get(this.generateRepository, new String[0]);
        if (!Files.exists(path, new LinkOption[0])) {
            try {
                Files.createDirectories(path, new FileAttribute[0]);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        while (true) {
            byte[] temp = sm.receivedKissData();
            try {
                Files.write(Paths.get(this.generateRepository + "\\Frame_" + cpt++ + ".bin", new String[0]), temp, new OpenOption[0]);
            }
            catch (IOException e) {
                this.log.severe(e.toString());
            }
            System.out.println("compteur" + cpt++);
        }
    }

    public static void main(String[] args) throws ParseException {
        boolean generateMode;
        boolean configMode;
        boolean versionpMode;
        Options options = SoundModemCli.configParameters();
        DefaultParser parser = new DefaultParser();
        CommandLine line = parser.parse(options, args);
        SoundModemCli smc = new SoundModemCli();
        System.out.println(SoundModemCli.class.getSimpleName() + " " + version);
        boolean helpMode = line.hasOption("help");
        if (helpMode) {
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp(args[0], options, true);
            System.exit(0);
        }
        if (versionpMode = line.hasOption("Version")) {
            System.out.println(SoundModemCli.class.getSimpleName() + " " + version);
            System.exit(0);
        }
        if (configMode = line.hasOption("Config")) {
            smc.setConfigurationfile(line.getOptionValue("Config", ""));
        }
        if (generateMode = line.hasOption("Generate")) {
            smc.setGenerateRepository(line.getOptionValue("Generate", ""));
        }
        smc.execute();
    }
}

