/*
 * Decompiled with CFR 0.152.
 */
package org.castor.core.util;

import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class Messages {
    private static final Log LOG = LogFactory.getLog(Messages.class);
    public static final String RESOURCE_NAME = "org.castor.messages";
    private static ResourceBundle _messages;
    private static Hashtable<String, MessageFormat> _formats;

    public static void setDefaultLocale() {
        Messages.setLocale(Locale.getDefault());
    }

    public static void setLocale(Locale locale) {
        try {
            _messages = ResourceBundle.getBundle(RESOURCE_NAME, locale);
        }
        catch (Exception except) {
            _messages = new EmptyResourceBundle();
            LOG.error("Failed to locate messages resource org.castor.messages");
        }
        _formats = new Hashtable();
    }

    public static String format(String message, Object arg1) {
        return Messages.format(message, new Object[]{arg1});
    }

    public static String format(String message, Object arg1, Object arg2) {
        return Messages.format(message, new Object[]{arg1, arg2});
    }

    public static String format(String message, Object arg1, Object arg2, Object arg3) {
        return Messages.format(message, new Object[]{arg1, arg2, arg3});
    }

    public static String format(String message, Object[] args) {
        try {
            MessageFormat mf = _formats.get(message);
            if (mf == null) {
                String msg;
                try {
                    msg = _messages.getString(message);
                }
                catch (MissingResourceException except) {
                    return message;
                }
                mf = new MessageFormat(msg);
                _formats.put(message, mf);
            }
            return mf.format(args);
        }
        catch (Exception except) {
            return "An internal error occured while processing message " + message;
        }
    }

    public static String message(String message) {
        try {
            return _messages.getString(message);
        }
        catch (MissingResourceException except) {
            return message;
        }
    }

    private Messages() {
    }

    static {
        Messages.setDefaultLocale();
    }

    private static class EmptyResourceBundle
    extends ResourceBundle
    implements Enumeration<String> {
        private EmptyResourceBundle() {
        }

        @Override
        public Enumeration<String> getKeys() {
            return this;
        }

        @Override
        protected Object handleGetObject(String name) {
            return "[Missing message " + name + "]";
        }

        @Override
        public boolean hasMoreElements() {
            return false;
        }

        @Override
        public String nextElement() {
            return null;
        }
    }
}

