/*
 * Decompiled with CFR 0.152.
 */
package org.josast.UVSQsatDecoder;

import java.io.File;
import java.io.IOException;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Logger;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.event.EventHandler;
import javafx.fxml.FXMLLoader;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.image.Image;
import javafx.stage.Stage;
import javafx.stage.WindowEvent;
import org.josast.UVSQsatDecoder.Controler;

public class App
extends Application {
    private static Scene scene;
    private static FXMLLoader fxmlLoader;
    private static Logger logger;

    @Override
    public void start(Stage stage) throws IOException {
        System.setProperty("glass.accessible.force", "false");
        scene = new Scene(App.loadFXML("UVSQsat"), 800.0, 600.0);
        stage.setScene(scene);
        stage.setOnCloseRequest(new EventHandler<WindowEvent>(){

            @Override
            public void handle(WindowEvent event) {
                Platform.exit();
                System.exit(0);
            }
        });
        Controler ctrl = (Controler)fxmlLoader.getController();
        ctrl.setPrimaryStage(stage);
        scene.getStylesheets().add(this.getClass().getResource("boot.css").toExternalForm());
        stage.setTitle("UVSQsat Decoder - " + ctrl.getversion());
        stage.getIcons().add(new Image(App.class.getResourceAsStream("OIP.jpg")));
        ctrl.initMMI();
        stage.show();
    }

    static void setRoot(String fxml) throws IOException {
        scene.setRoot(App.loadFXML(fxml));
    }

    private static Parent loadFXML(String fxml) throws IOException {
        fxmlLoader = new FXMLLoader(App.class.getResource(fxml + ".fxml"));
        logger.info("class " + App.class.getResource(fxml + ".fxml").getFile().toString());
        return (Parent)fxmlLoader.load();
    }

    public static void main(String[] args) {
        try {
            Handler[] handlers;
            String path = System.getProperty("user.dir") + "/log";
            File apath = new File(path);
            if (!apath.exists() && !apath.mkdir()) {
                logger.severe("fail to create " + path);
            }
            FileHandler fh = new FileHandler(path + "/UVSQsat.log");
            logger.setUseParentHandlers(false);
            for (Handler handler : handlers = logger.getHandlers()) {
                logger.removeHandler(handler);
            }
            logger.addHandler(fh);
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        App.launch(new String[0]);
    }

    static {
        logger = Logger.getLogger("AmsatLogger");
    }
}

