/*
 * Decompiled with CFR 0.152.
 */
package org.josast.SIDS;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.apache.http.NameValuePair;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.TrustStrategy;
import org.josast.SIDS.SIDSData;

public class HttpPostSIDS {
    private static Logger logger = Logger.getLogger("AmsatLogger");
    private static String USERAGENT = "Mozilla/5.0";
    private CloseableHttpClient client = this.getCloseableHttpClient();
    private HttpPost post = null;
    private StringBuffer result = null;

    public HttpPostSIDS(String url) {
        this.post = new HttpPost(url);
        this.post.setHeader("User-Agent", USERAGENT);
    }

    public HttpPostSIDS(String url, String token) {
        this.post = new HttpPost(url);
        this.post.setHeader("User-Agent", USERAGENT);
        this.addSatnogsToken(token);
    }

    public void addSatnogsToken(String token) {
        this.post.addHeader("Authorization", "Token " + token);
    }

    private CloseableHttpClient getCloseableHttpClient() {
        CloseableHttpClient httpClient = null;
        try {
            httpClient = HttpClients.custom().setSSLHostnameVerifier(NoopHostnameVerifier.INSTANCE).setSSLContext(new SSLContextBuilder().loadTrustMaterial(null, new TrustStrategy(){

                @Override
                public boolean isTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
                    return true;
                }
            }).build()).build();
        }
        catch (KeyManagementException e) {
            logger.severe("KeyManagementException in creating http client instance " + e.toString());
        }
        catch (NoSuchAlgorithmException e) {
            logger.severe("NoSuchAlgorithmException in creating http client instance " + e.toString());
        }
        catch (KeyStoreException e) {
            logger.severe("KeyStoreException in creating http client instance " + e.toString());
        }
        return httpClient;
    }

    public int SendSIDSBasic(SIDSData sids) {
        int resultat = 0;
        CloseableHttpResponse response = null;
        BufferedReader rd = null;
        ArrayList<BasicNameValuePair> urlParameters = new ArrayList<BasicNameValuePair>();
        urlParameters.add(new BasicNameValuePair("noradID", "" + sids.getNoradID()));
        urlParameters.add(new BasicNameValuePair("source", sids.getSource()));
        urlParameters.add(new BasicNameValuePair("timestamp", sids.getTimestamp()));
        urlParameters.add(new BasicNameValuePair("frame", sids.getFrame()));
        urlParameters.add(new BasicNameValuePair("locator", sids.getLocator()));
        urlParameters.add(new BasicNameValuePair("longitude", "" + sids.getLongitude()));
        urlParameters.add(new BasicNameValuePair("latitude", "" + sids.getLatitude()));
        urlParameters.add(new BasicNameValuePair("version", "2.0.2"));
        try {
            this.post.setEntity(new UrlEncodedFormEntity((List<? extends NameValuePair>)urlParameters));
        }
        catch (UnsupportedEncodingException e) {
            logger.severe("URL Encoding error" + e);
        }
        try {
            response = this.client.execute(this.post);
            resultat = response.getStatusLine().getStatusCode();
            logger.info("URL Result " + resultat);
            logger.info("URL Result " + response.getAllHeaders());
        }
        catch (IOException e) {
            logger.severe("Cient executon error" + e.toString());
        }
        if (response != null) {
            try {
                rd = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
            }
            catch (IOException | UnsupportedOperationException e) {
                logger.severe("Buffer reader Exception " + e.toString());
            }
            this.result = new StringBuffer();
            String line = "";
            try {
                while ((line = rd.readLine()) != null) {
                    this.result.append(line);
                }
            }
            catch (IOException e) {
                logger.severe("Error reading line from server  " + e.toString());
            }
        }
        return resultat;
    }

    public StringBuffer getResult() {
        return this.result;
    }
}

