/*
 * Decompiled with CFR 0.152.
 */
package org.josast.ApplicationKissTool;

import java.math.BigInteger;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.concurrent.BlockingQueue;
import javafx.application.Platform;
import javafx.concurrent.Task;
import org.josast.ApplicationKissTool.Ax25Display;
import org.josast.ApplicationKissTool.Configuration;
import org.josast.ApplicationKissTool.Controler;
import org.josast.ApplicationKissTool.DisplayUVSQsat;
import org.josast.ApplicationKissTool.ManageDataFile;
import org.josast.ApplicationKissTool.ModelReceivedData;
import org.josast.ApplicationKissTool.ReceivedData;
import org.josast.ApplicationKissTool.TlmData;

public class TaskManageReceivedData
extends Task<String> {
    private final SimpleDateFormat ISO8601DATEFORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
    private final Configuration conf = Configuration.getInstance();
    private Ax25Display ax25display = new Ax25Display();
    private ManageDataFile mdf = new ManageDataFile();
    private DisplayUVSQsat displayUVSQsat = new DisplayUVSQsat();
    private BlockingQueue<ReceivedData> blockingQueue = null;
    private ModelReceivedData datamodel = null;
    Controler ctrl = null;

    public TaskManageReceivedData(BlockingQueue<ReceivedData> blockingQueueIn, Controler ctrlIn) {
        this.blockingQueue = blockingQueueIn;
        this.ctrl = ctrlIn;
    }

    public TaskManageReceivedData(BlockingQueue<ReceivedData> blockingQueueIn, ModelReceivedData datamodel) {
        this.blockingQueue = blockingQueueIn;
        this.datamodel = datamodel;
    }

    private void displayLog(final String string) {
        Platform.runLater(new Runnable(){

            @Override
            public void run() {
                try {
                    TaskManageReceivedData.this.ctrl.displayLog(string);
                }
                catch (Exception e) {
                    TaskManageReceivedData.this.displayLog("Run - error");
                    TaskManageReceivedData.this.displayLog(e.toString());
                    e.printStackTrace();
                }
            }
        });
    }

    private void displayData(final ReceivedData decodedData) {
        Platform.runLater(new Runnable(){

            @Override
            public void run() {
                try {
                    if (!TaskManageReceivedData.this.conf.isSilentMode()) {
                        TaskManageReceivedData.this.ctrl.displayLog(decodedData.toString());
                        TaskManageReceivedData.this.ctrl.SetDecodedData(TaskManageReceivedData.this.ax25display.getDisplay());
                        if (TaskManageReceivedData.this.ax25display.GetCallsignFrom().contains("LATMOS")) {
                            TaskManageReceivedData.this.displayUVSQsat.setData(decodedData);
                            TaskManageReceivedData.this.ctrl.SetDecodedData(TaskManageReceivedData.this.displayUVSQsat.getData());
                        }
                    }
                    TaskManageReceivedData.this.ctrl.SendSids(decodedData);
                    TaskManageReceivedData.this.ctrl.IncrementNbFrameTraited();
                }
                catch (Exception e) {
                    TaskManageReceivedData.this.displayLog("Run - error");
                    TaskManageReceivedData.this.displayLog(e.toString());
                    e.printStackTrace();
                }
            }
        });
    }

    @Override
    protected String call() throws Exception {
        System.out.println("tache message lanc\u00e9ee");
        this.displayLog("Waiting Data !!!");
        while (true) {
            ReceivedData decodedData = this.blockingQueue.take();
            this.displayLog(" Data !!!");
            this.ax25display.setdata(decodedData);
            String calsignr = this.ax25display.GetCallsignFrom();
            if (calsignr != null) {
                this.displayLog(" calsign" + calsignr);
            } else {
                this.displayLog(" calsign not decoded");
            }
            Date lastFrameTime = new Date();
            String creationdate = this.ISO8601DATEFORMAT.format(lastFrameTime);
            String hexaString = new BigInteger(1, decodedData.getData()).toString(16);
            TlmData tlmData = new TlmData(hexaString, this.ax25display.GetCallsignFrom(), this.conf.getLongitude(), this.conf.getLatitude(), creationdate);
            if (this.mdf.saveTlmData(tlmData) != 0) {
                this.displayLog("Error creation JSON file");
            }
            this.displayData(decodedData);
        }
    }
}

