/*
 * Decompiled with CFR 0.152.
 */
package org.josast.ApplicationKissTool;

import java.io.File;
import java.io.IOException;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Logger;
import javafx.application.Application;
import javafx.fxml.FXMLLoader;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.stage.Stage;
import org.josast.ApplicationKissTool.Controler;

public class App
extends Application {
    private static Scene scene;
    private static FXMLLoader fxmlLoader;
    private static Logger logger;

    @Override
    public void start(Stage stage) throws IOException {
        System.setProperty("glass.accessible.force", "false");
        scene = new Scene(App.loadFXML("KissTool"), 800.0, 600.0);
        stage.setScene(scene);
        Controler ctrl = (Controler)fxmlLoader.getController();
        ctrl.setPrimaryStage(stage);
        scene.getStylesheets().add(this.getClass().getResource("boot.css").toExternalForm());
        stage.setTitle("KISS tool -UVSQSAT Dedicated " + ctrl.getVersion());
        stage.setOnCloseRequest(e -> System.exit(0));
        ctrl.initMMI();
        stage.show();
    }

    private static Parent loadFXML(String fxml) throws IOException {
        fxmlLoader = new FXMLLoader(App.class.getResource(fxml + ".fxml"));
        return (Parent)fxmlLoader.load();
    }

    public static void main(String[] args) {
        try {
            Handler[] handlers;
            String path = System.getProperty("user.dir") + "/log";
            File apath = new File(path);
            if (!apath.exists() && !apath.mkdir()) {
                System.err.println("fail to create " + path);
            }
            FileHandler fh = new FileHandler(path + "/KissTool.log.xml");
            logger.setUseParentHandlers(false);
            for (Handler handler : handlers = logger.getHandlers()) {
                logger.removeHandler(handler);
            }
            logger.addHandler(fh);
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        App.launch(new String[0]);
    }

    static {
        logger = Logger.getLogger("AmsatLogger");
    }
}

