/*
 * Decompiled with CFR 0.152.
 */
package io.kaitai.struct;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.util.Arrays;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;

public abstract class KaitaiStream
implements Closeable {
    protected int bitsLeft = 0;
    protected long bits = 0L;
    private static final int ZLIB_BUF_SIZE = 4096;

    @Override
    public abstract void close() throws IOException;

    public abstract boolean isEof();

    public abstract void seek(int var1);

    public abstract void seek(long var1);

    public abstract int pos();

    public abstract long size();

    public abstract byte readS1();

    public abstract short readS2be();

    public abstract int readS4be();

    public abstract long readS8be();

    public abstract short readS2le();

    public abstract int readS4le();

    public abstract long readS8le();

    public abstract int readU1();

    public abstract int readU2be();

    public abstract long readU4be();

    public long readU8be() {
        return this.readS8be();
    }

    public abstract int readU2le();

    public abstract long readU4le();

    public long readU8le() {
        return this.readS8le();
    }

    public abstract float readF4be();

    public abstract double readF8be();

    public abstract float readF4le();

    public abstract double readF8le();

    public void alignToByte() {
        this.bits = 0L;
        this.bitsLeft = 0;
    }

    public long readBitsIntBe(int n) {
        int bitsNeeded = n - this.bitsLeft;
        if (bitsNeeded > 0) {
            byte[] buf;
            int bytesNeeded = (bitsNeeded - 1) / 8 + 1;
            for (byte b : buf = this.readBytes(bytesNeeded)) {
                this.bits <<= 8;
                this.bits |= (long)(b & 0xFF);
                this.bitsLeft += 8;
            }
        }
        long mask = KaitaiStream.getMaskOnes(n);
        int shiftBits = this.bitsLeft - n;
        long res = this.bits >>> shiftBits & mask;
        this.bitsLeft -= n;
        mask = KaitaiStream.getMaskOnes(this.bitsLeft);
        this.bits &= mask;
        return res;
    }

    @Deprecated
    public long readBitsInt(int n) {
        return this.readBitsIntBe(n);
    }

    public long readBitsIntLe(int n) {
        int bitsNeeded = n - this.bitsLeft;
        if (bitsNeeded > 0) {
            byte[] buf;
            int bytesNeeded = (bitsNeeded - 1) / 8 + 1;
            for (byte b : buf = this.readBytes(bytesNeeded)) {
                this.bits |= (long)(b & 0xFF) << this.bitsLeft;
                this.bitsLeft += 8;
            }
        }
        long mask = KaitaiStream.getMaskOnes(n);
        long res = this.bits & mask;
        this.bits >>= n;
        this.bitsLeft -= n;
        return res;
    }

    private static long getMaskOnes(int n) {
        if (n == 64) {
            return -1L;
        }
        return (1L << n) - 1L;
    }

    public abstract byte[] readBytes(long var1);

    public abstract byte[] readBytesFull();

    public abstract byte[] readBytesTerm(int var1, boolean var2, boolean var3, boolean var4);

    @Deprecated
    public byte[] ensureFixedContents(byte[] expected) {
        byte[] actual = this.readBytes(expected.length);
        if (!Arrays.equals(actual, expected)) {
            throw new UnexpectedDataError(actual, expected);
        }
        return actual;
    }

    public static byte[] bytesStripRight(byte[] bytes, byte padByte) {
        int newLen;
        for (newLen = bytes.length; newLen > 0 && bytes[newLen - 1] == padByte; --newLen) {
        }
        return Arrays.copyOf(bytes, newLen);
    }

    public static byte[] bytesTerminate(byte[] bytes, byte term, boolean includeTerm) {
        int newLen;
        int maxLen = bytes.length;
        for (newLen = 0; newLen < maxLen && bytes[newLen] != term; ++newLen) {
        }
        if (includeTerm && newLen < maxLen) {
            ++newLen;
        }
        return Arrays.copyOf(bytes, newLen);
    }

    protected int toByteArrayLength(long n) {
        if (n > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Java byte arrays can be indexed only up to 31 bits, but " + n + " size was requested");
        }
        if (n < 0L) {
            throw new IllegalArgumentException("Byte array size can't be negative, but " + n + " size was requested");
        }
        return (int)n;
    }

    public static byte[] processXor(byte[] data, int key) {
        int dataLen = data.length;
        byte[] r = new byte[dataLen];
        for (int i = 0; i < dataLen; ++i) {
            r[i] = (byte)(data[i] ^ key);
        }
        return r;
    }

    public static byte[] processXor(byte[] data, byte[] key) {
        int dataLen = data.length;
        int valueLen = key.length;
        byte[] r = new byte[dataLen];
        int j = 0;
        for (int i = 0; i < dataLen; ++i) {
            r[i] = (byte)(data[i] ^ key[j]);
            j = (j + 1) % valueLen;
        }
        return r;
    }

    public static byte[] processRotateLeft(byte[] data, int amount, int groupSize) {
        byte[] r = new byte[data.length];
        switch (groupSize) {
            case 1: {
                for (int i = 0; i < data.length; ++i) {
                    byte bits = data[i];
                    r[i] = (byte)((bits & 0xFF) << amount | (bits & 0xFF) >>> 8 - amount);
                }
                break;
            }
            default: {
                throw new UnsupportedOperationException("unable to rotate group of " + groupSize + " bytes yet");
            }
        }
        return r;
    }

    public static byte[] processZlib(byte[] data) {
        Inflater ifl = new Inflater();
        ifl.setInput(data);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buf = new byte[4096];
        while (!ifl.finished()) {
            try {
                int decBytes = ifl.inflate(buf);
                baos.write(buf, 0, decBytes);
            }
            catch (DataFormatException e) {
                throw new RuntimeException(e);
            }
        }
        ifl.end();
        return baos.toByteArray();
    }

    public static int mod(int a, int b) {
        if (b <= 0) {
            throw new ArithmeticException("mod divisor <= 0");
        }
        int r = a % b;
        if (r < 0) {
            r += b;
        }
        return r;
    }

    public static long mod(long a, long b) {
        if (b <= 0L) {
            throw new ArithmeticException("mod divisor <= 0");
        }
        long r = a % b;
        if (r < 0L) {
            r += b;
        }
        return r;
    }

    public static int byteArrayCompare(byte[] a, byte[] b) {
        if (a == b) {
            return 0;
        }
        int al = a.length;
        int bl = b.length;
        int minLen = Math.min(al, bl);
        for (int i = 0; i < minLen; ++i) {
            int cmp = (a[i] & 0xFF) - (b[i] & 0xFF);
            if (cmp == 0) continue;
            return cmp;
        }
        if (al == bl) {
            return 0;
        }
        return al - bl;
    }

    public static int byteArrayMin(byte[] b) {
        int min = Integer.MAX_VALUE;
        for (int i = 0; i < b.length; ++i) {
            int value = b[i] & 0xFF;
            if (value >= min) continue;
            min = value;
        }
        return min;
    }

    public static int byteArrayMax(byte[] b) {
        int max = 0;
        for (int i = 0; i < b.length; ++i) {
            int value = b[i] & 0xFF;
            if (value <= max) continue;
            max = value;
        }
        return max;
    }

    public static class ValidationExprError
    extends ValidationFailedError {
        protected Object actual;

        public ValidationExprError(Object actual, KaitaiStream io, String srcPath) {
            super("not matching the expression, got " + actual, io, srcPath);
        }
    }

    public static class ValidationNotAnyOfError
    extends ValidationFailedError {
        protected Object actual;

        public ValidationNotAnyOfError(Object actual, KaitaiStream io, String srcPath) {
            super("not any of the list, got " + actual, io, srcPath);
        }
    }

    public static class ValidationGreaterThanError
    extends ValidationFailedError {
        protected Object max;
        protected Object actual;

        public ValidationGreaterThanError(byte[] expected, byte[] actual, KaitaiStream io, String srcPath) {
            super("not in range, max " + ValidationGreaterThanError.byteArrayToHex(expected) + ", but got " + ValidationGreaterThanError.byteArrayToHex(actual), io, srcPath);
        }

        public ValidationGreaterThanError(Object max, Object actual, KaitaiStream io, String srcPath) {
            super("not in range, max " + max + ", but got " + actual, io, srcPath);
        }
    }

    public static class ValidationLessThanError
    extends ValidationFailedError {
        protected Object min;
        protected Object actual;

        public ValidationLessThanError(byte[] expected, byte[] actual, KaitaiStream io, String srcPath) {
            super("not in range, min " + ValidationLessThanError.byteArrayToHex(expected) + ", but got " + ValidationLessThanError.byteArrayToHex(actual), io, srcPath);
        }

        public ValidationLessThanError(Object min, Object actual, KaitaiStream io, String srcPath) {
            super("not in range, min " + min + ", but got " + actual, io, srcPath);
        }
    }

    public static class ValidationNotEqualError
    extends ValidationFailedError {
        protected Object expected;
        protected Object actual;

        public ValidationNotEqualError(byte[] expected, byte[] actual, KaitaiStream io, String srcPath) {
            super("not equal, expected " + ValidationNotEqualError.byteArrayToHex(expected) + ", but got " + ValidationNotEqualError.byteArrayToHex(actual), io, srcPath);
        }

        public ValidationNotEqualError(Object expected, Object actual, KaitaiStream io, String srcPath) {
            super("not equal, expected " + expected + ", but got " + actual, io, srcPath);
        }
    }

    public static class ValidationFailedError
    extends KaitaiStructError {
        protected KaitaiStream io;

        public ValidationFailedError(String msg, KaitaiStream io, String srcPath) {
            super("at pos " + io.pos() + ": validation failed: " + msg, srcPath);
            this.io = io;
        }

        protected static String byteArrayToHex(byte[] arr) {
            StringBuilder sb = new StringBuilder("[");
            for (int i = 0; i < arr.length; ++i) {
                if (i > 0) {
                    sb.append(' ');
                }
                sb.append(String.format("%02x", arr[i]));
            }
            sb.append(']');
            return sb.toString();
        }
    }

    public static class KaitaiStructError
    extends RuntimeException {
        protected String srcPath;

        public KaitaiStructError(String msg, String srcPath) {
            super(srcPath + ": " + msg);
            this.srcPath = srcPath;
        }
    }

    public static class UndecidedEndiannessError
    extends RuntimeException {
    }

    @Deprecated
    public static class UnexpectedDataError
    extends RuntimeException {
        public UnexpectedDataError(byte[] actual, byte[] expected) {
            super("Unexpected fixed contents: got " + UnexpectedDataError.byteArrayToHex(actual) + ", was waiting for " + UnexpectedDataError.byteArrayToHex(expected));
        }

        private static String byteArrayToHex(byte[] arr) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < arr.length; ++i) {
                if (i > 0) {
                    sb.append(' ');
                }
                sb.append(String.format("%02x", arr[i]));
            }
            return sb.toString();
        }
    }
}

