/*
 * Decompiled with CFR 0.152.
 */
package org.josast.UVSQsatDecoder;

import java.util.logging.Logger;
import javafx.concurrent.Task;
import org.josast.ModuleSoundModem.SoundModemClient;
import org.josast.ModuleSoundModem.SoundModemConfiguration;
import org.josast.UVSQsatDecoder.ModelReceivedData;

public class TaskSoundmodemTCP
extends Task<String> {
    private Logger log = Logger.getLogger("AmsatLogger");
    private volatile boolean running = true;
    SoundModemConfiguration smConfiguration = null;
    SoundModemClient smc = null;
    ModelReceivedData receivedFrame = null;

    public TaskSoundmodemTCP(SoundModemConfiguration smConfiguration, ModelReceivedData receivedFrame) {
        this.smConfiguration = smConfiguration;
        this.smc = new SoundModemClient(smConfiguration);
        if (!this.smc.isOpen()) {
            this.failed();
        }
        this.receivedFrame = receivedFrame;
    }

    public TaskSoundmodemTCP(ModelReceivedData receivedFrame) {
        this.smConfiguration = new SoundModemConfiguration("default");
        this.smc = new SoundModemClient(this.smConfiguration);
        if (!this.smc.isOpen()) {
            this.failed();
        }
        this.receivedFrame = receivedFrame;
    }

    @Override
    protected String call() {
        try {
            while (this.running) {
                if (this.smc.isOpen()) {
                    byte[] temp = this.smc.receivedRawData();
                    this.receivedFrame.addFrame(temp);
                    this.updateValue(this.receivedFrame.toString());
                    temp = null;
                    continue;
                }
                this.running = false;
                this.log.severe("Erreur SoundModem closed");
            }
        }
        catch (Exception e) {
            this.log.severe("Erreur SoundModem not available");
            this.log.severe(e.toString());
            this.failed();
        }
        return this.receivedFrame.toString();
    }

    public void arreter() {
        this.running = false;
    }

    public void redemarrer() {
        this.running = true;
    }
}

