/*
 * Decompiled with CFR 0.152.
 */
package org.josast.AX25;

import io.kaitai.struct.ByteBufferKaitaiStream;
import org.josast.AX25.generated.Ax25frames;

public class AX25DecodedData {
    private Ax25frames ax25frames = null;
    public String source;
    private String destination;
    private int PID;
    private int destSSID;
    private int srcSSID;
    private int ctl;

    public AX25DecodedData(byte[] data) {
        this.ax25frames = new Ax25frames(new ByteBufferKaitaiStream(data));
        this.source = this.ax25frames.ax25Frame().ax25Header().srcCallsignRaw().callsignRor().callsign();
        this.destination = this.ax25frames.ax25Frame().ax25Header().destCallsignRaw().callsignRor().callsign();
        this.PID = this.ax25frames.ax25Frame().pid();
        this.destSSID = this.ax25frames.ax25Frame().ax25Header().destSsidRaw().ssid();
        this.srcSSID = this.ax25frames.ax25Frame().ax25Header().srcSsidRaw().ssid();
        this.ctl = this.ax25frames.ax25Frame().ax25Header().ctl();
    }

    public String toStringHeader() {
        String sep = "\r\n";
        return "Source : " + this.source + " - SSID : " + this.srcSSID + sep + "Destination :" + this.destination + " - SSID : " + this.destSSID + sep + "PID :" + this.PID + sep + " ctl : " + this.ctl + sep;
    }

    public String toStringData() {
        byte[] bytes;
        StringBuffer buffer = new StringBuffer();
        for (byte b : bytes = this.ax25frames.ax25Frame().ax25Info()) {
            buffer.append(String.format("%02X ", b));
        }
        return buffer.toString();
    }
}

