/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.dsml;

import java.io.Serializable;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Vector;
import org.castor.core.util.Messages;
import org.xml.sax.AttributeList;
import org.xml.sax.DocumentHandler;
import org.xml.sax.HandlerBase;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributeListImpl;

public class SearchDescriptor
extends HandlerBase
implements Serializable {
    private static final long serialVersionUID = -6614367393322175115L;
    private int _scope = 1;
    private String _baseDN;
    private String _filter;
    private Vector<String> _returnAttrs;
    private StringBuffer _attrName;
    private boolean _insideRoot;

    public int getScope() {
        return this._scope;
    }

    public void setScope(int scope) {
        this._scope = scope;
    }

    public String getBaseDN() {
        return this._baseDN;
    }

    public void setBaseDN(String baseDN) {
        this._baseDN = baseDN;
    }

    public String getFilter() {
        return this._filter;
    }

    public void setFilter(String filter) {
        this._filter = filter;
    }

    public String[] getReturnAttrs() {
        if (this._returnAttrs == null) {
            return null;
        }
        return this._returnAttrs.toArray(new String[this._returnAttrs.size()]);
    }

    public Enumeration<String> listReturnAttrs() {
        if (this._returnAttrs == null) {
            return Collections.emptyEnumeration();
        }
        return this._returnAttrs.elements();
    }

    public void addReturnAttr(String attrName) {
        if (this._returnAttrs == null) {
            this._returnAttrs = new Vector();
        }
        if (!this._returnAttrs.contains(attrName)) {
            this._returnAttrs.add(attrName);
        }
    }

    public void produce(DocumentHandler docHandler) throws SAXException {
        AttributeListImpl attrList = new AttributeListImpl();
        docHandler.startElement("dsml", attrList);
        attrList = new AttributeListImpl();
        if (this._baseDN != null) {
            attrList.addAttribute("base", "CDATA", this._baseDN);
        }
        if (this._filter != null) {
            attrList.addAttribute("filter", "CDATA", this._filter);
        }
        switch (this._scope) {
            case 0: {
                attrList.addAttribute("scope", null, "onelevel");
                break;
            }
            case 1: {
                attrList.addAttribute("scope", null, "base");
                break;
            }
            case 3: {
                attrList.addAttribute("scope", null, "subtree");
            }
        }
        docHandler.startElement("search", attrList);
        if (this._returnAttrs != null) {
            Enumeration<String> enumeration = this._returnAttrs.elements();
            while (enumeration.hasMoreElements()) {
                attrList = new AttributeListImpl();
                attrList.addAttribute("name", "NMTOKEN", enumeration.nextElement());
                docHandler.startElement("return-attr", attrList);
                docHandler.endElement("return-attr");
            }
        }
        docHandler.endElement("search");
        docHandler.endElement("dsml");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void startElement(String tagName, AttributeList attr) throws SAXException {
        if (tagName.equals("dsml")) {
            if (this._insideRoot) {
                throw new SAXException(Messages.format("dsml.elementNested", "dsml"));
            }
            this._insideRoot = true;
            return;
        } else {
            if (!this._insideRoot) {
                throw new SAXException(Messages.format("dsml.expectingOpeningTag", "dsml", tagName));
            }
            if (tagName.equals("search")) {
                this._baseDN = attr.getValue("base");
                if (this._baseDN == null) {
                    throw new SAXException(Messages.format("dsml.missingAttribute", "search", "base"));
                }
                this._filter = attr.getValue("filter");
                String value = attr.getValue("scope");
                if (value == null) return;
                if (value.equals("onelevel")) {
                    this._scope = 0;
                    return;
                } else if (value.equals("base")) {
                    this._scope = 1;
                    return;
                } else {
                    if (!value.equals("subtree")) throw new SAXException(Messages.format("dsml.invalidValue", "scope", value));
                    this._scope = 3;
                }
                return;
            } else {
                if (!tagName.equals("return-attr")) throw new SAXException(Messages.format("dsml.expectingOpeningTag", "search", tagName));
                if (this._baseDN == null) {
                    throw new SAXException(Messages.format("dsml.expectingOpeningTag", "search", tagName));
                }
                this._attrName = new StringBuffer();
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void endElement(String tagName) throws SAXException {
        if (tagName.equals("dsml")) {
            if (!this._insideRoot) throw new SAXException(Messages.format("dsml.closingOutsideRoot", tagName));
            this._insideRoot = false;
            return;
        } else {
            if (!this._insideRoot) {
                throw new SAXException(Messages.format("dsml.closingOutsideRoot", tagName));
            }
            if (tagName.equals("search")) return;
            if (!tagName.equals("return-attr")) throw new SAXException(Messages.format("dsml.expectingClosingTag", "search", tagName));
            if (this._attrName.length() <= 0) return;
            this.addReturnAttr(this._attrName.toString());
            this._attrName = null;
        }
    }

    @Override
    public void characters(char[] ch, int offset, int length) {
        if (this._attrName != null) {
            this._attrName.append(ch, offset, length);
        }
    }

    static class Names {
        Names() {
        }

        static class Attribute {
            public static final String ATTRIBUTE_NAME = "name";
            public static final String BASE_DN = "base";
            public static final String SCOPE = "scope";
            public static final String FILTER = "filter";
            public static final String SCOPE_ONE_LEVEL = "onelevel";
            public static final String SCOPE_BASE = "base";
            public static final String SCOPE_SUB_TREE = "subtree";

            Attribute() {
            }
        }

        static class Element {
            public static final String SEARCH = "search";
            public static final String RETURN_ATTRIBUTE = "return-attr";

            Element() {
            }
        }
    }

    public static class Scope {
        public static final int ONE_LEVEL = 0;
        public static final int BASE = 1;
        public static final int SUB_TREE = 3;
    }
}

