/*
 * Decompiled with CFR 0.152.
 */
package org.slf4j.impl;

import org.apache.maven.plugin.logging.Log;
import org.slf4j.helpers.FormattingTuple;
import org.slf4j.helpers.MarkerIgnoringBase;
import org.slf4j.helpers.MessageFormatter;

final class Slf4jAdapter
extends MarkerIgnoringBase {
    public static final long serialVersionUID = 1351246359409939513L;
    private final transient Log mlog;
    private final transient String label;

    public Slf4jAdapter(Log log, String name) {
        this.mlog = log;
        this.label = name;
    }

    @Override
    public String getName() {
        return this.getClass().getName();
    }

    @Override
    public boolean isTraceEnabled() {
        return false;
    }

    @Override
    public void trace(String msg) {
        this.mlog.debug((CharSequence)this.decorate(msg));
    }

    @Override
    public void trace(String format, Object arg) {
        this.mlog.debug((CharSequence)this.decorate(this.format(format, arg)));
    }

    @Override
    public void trace(String format, Object first, Object second) {
        this.mlog.debug((CharSequence)this.decorate(this.format(format, first, second)));
    }

    @Override
    public void trace(String format, Object ... array) {
        this.mlog.debug((CharSequence)this.decorate(this.format(format, array)));
    }

    @Override
    public void trace(String msg, Throwable thr) {
        this.mlog.debug((CharSequence)this.decorate(msg), thr);
    }

    @Override
    public boolean isDebugEnabled() {
        return this.mlog.isDebugEnabled();
    }

    @Override
    public void debug(String msg) {
        this.mlog.debug((CharSequence)this.decorate(msg));
    }

    @Override
    public void debug(String format, Object arg) {
        this.mlog.debug((CharSequence)this.decorate(this.format(format, arg)));
    }

    @Override
    public void debug(String format, Object first, Object second) {
        this.mlog.debug((CharSequence)this.decorate(this.format(format, first, second)));
    }

    @Override
    public void debug(String format, Object ... array) {
        this.mlog.debug((CharSequence)this.decorate(this.format(format, array)));
    }

    @Override
    public void debug(String msg, Throwable thr) {
        this.mlog.debug((CharSequence)this.decorate(msg), thr);
    }

    @Override
    public boolean isInfoEnabled() {
        return true;
    }

    @Override
    public void info(String msg) {
        this.mlog.info((CharSequence)msg);
    }

    @Override
    public void info(String format, Object arg) {
        this.mlog.info((CharSequence)this.format(format, arg));
    }

    @Override
    public void info(String format, Object first, Object second) {
        this.mlog.info((CharSequence)this.format(format, first, second));
    }

    @Override
    public void info(String format, Object ... array) {
        this.mlog.info((CharSequence)this.format(format, array));
    }

    @Override
    public void info(String msg, Throwable thr) {
        this.mlog.info((CharSequence)msg, thr);
    }

    @Override
    public boolean isWarnEnabled() {
        return true;
    }

    @Override
    public void warn(String msg) {
        this.mlog.warn((CharSequence)msg);
    }

    @Override
    public void warn(String format, Object arg) {
        this.mlog.warn((CharSequence)this.format(format, arg));
    }

    @Override
    public void warn(String format, Object ... array) {
        this.mlog.warn((CharSequence)this.format(format, array));
    }

    @Override
    public void warn(String format, Object first, Object second) {
        this.mlog.warn((CharSequence)this.format(format, first, second));
    }

    @Override
    public void warn(String msg, Throwable thr) {
        this.mlog.warn((CharSequence)msg, thr);
    }

    @Override
    public boolean isErrorEnabled() {
        return true;
    }

    @Override
    public void error(String msg) {
        this.mlog.error((CharSequence)msg);
    }

    @Override
    public void error(String format, Object arg) {
        this.mlog.error((CharSequence)this.format(format, arg));
    }

    @Override
    public void error(String format, Object first, Object second) {
        this.mlog.error((CharSequence)this.format(format, first, second));
    }

    @Override
    public void error(String format, Object ... array) {
        this.mlog.error((CharSequence)this.format(format, array));
    }

    @Override
    public void error(String msg, Throwable thr) {
        this.mlog.error((CharSequence)msg, thr);
    }

    private String format(String format, Object arg) {
        FormattingTuple tuple = MessageFormatter.format(format, arg);
        return tuple.getMessage();
    }

    private String format(String format, Object first, Object second) {
        FormattingTuple tuple = MessageFormatter.format(format, first, second);
        return tuple.getMessage();
    }

    private String format(String format, Object[] array) {
        FormattingTuple tuple = MessageFormatter.format(format, array);
        return tuple.getMessage();
    }

    private String decorate(String msg) {
        return String.format("%s %s: %s", Thread.currentThread().getName(), this.label, msg);
    }

    @Override
    public String toString() {
        return "Slf4jAdapter(mlog=" + this.mlog + ", label=" + this.label + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Slf4jAdapter)) {
            return false;
        }
        Slf4jAdapter other = (Slf4jAdapter)o;
        return other.canEqual(this);
    }

    protected boolean canEqual(Object other) {
        return other instanceof Slf4jAdapter;
    }

    public int hashCode() {
        int result = 1;
        return result;
    }
}

