/*
 * Decompiled with CFR 0.152.
 */
package org.josast.uvsqsat;

import java.util.logging.Logger;
import org.josast.uvsqsat.AX25decodedData;
import org.josast.uvsqsat.PPrimaryHeader;
import org.josast.uvsqsat.PSecondaryHeader;
import org.josast.uvsqsat.generated.Uvsqsat;
import org.josast.uvsqsat.pojogenerated.AFrame;
import org.josast.uvsqsat.pojogenerated.antsHk;
import org.josast.uvsqsat.pojogenerated.beacon;
import org.josast.uvsqsat.pojogenerated.iepsHkStatus;
import org.josast.uvsqsat.pojogenerated.imtqHk;
import org.josast.uvsqsat.pojogenerated.mainboardAllScience;
import org.josast.uvsqsat.pojogenerated.mainboardHk;
import org.josast.uvsqsat.pojogenerated.msgOrUnknow;
import org.josast.uvsqsat.pojogenerated.obcHk;
import org.josast.uvsqsat.pojogenerated.obcStatus;
import org.josast.uvsqsat.pojogenerated.trxvurxHk;
import org.josast.uvsqsat.pojogenerated.trxvutxHk;

public class Frame {
    private static Logger appLogger = Logger.getLogger("AmsatLogger");
    protected Uvsqsat UvsqsatData = null;
    protected PPrimaryHeader packetPrimaryHeader = null;
    protected PSecondaryHeader packetSecondaryHeader = null;
    protected String separator = "\r\n";
    private int sid;
    protected Uvsqsat.UiFrame uiFrame;
    protected AFrame tlm;
    protected AX25decodedData ax25;

    public void setUp(Uvsqsat data) {
        this.UvsqsatData = data;
        try {
            this.uiFrame = (Uvsqsat.UiFrame)data.ax25Frame().payload();
            this.ax25 = new AX25decodedData(data);
            this.packetPrimaryHeader = new PPrimaryHeader(this.uiFrame.packetPrimaryHeader());
            this.packetSecondaryHeader = new PSecondaryHeader(this.uiFrame.packetSecondaryHeader());
            this.sid = this.packetSecondaryHeader.getSid();
            this.extractTlm();
        }
        catch (Exception e) {
            appLogger.severe("Error decoding packet " + e.getStackTrace().toString());
        }
    }

    private void extractTlm() {
        switch (this.sid) {
            case 14: {
                break;
            }
            case 15: {
                this.tlm = new beacon((Uvsqsat.Beacon)this.uiFrame.tlm());
                break;
            }
            case 16: {
                this.tlm = new antsHk((Uvsqsat.AntsHk)this.uiFrame.tlm());
                break;
            }
            case 17: {
                this.tlm = new obcStatus((Uvsqsat.ObcStatus)this.uiFrame.tlm());
                break;
            }
            case 18: {
                this.tlm = new obcHk((Uvsqsat.ObcHk)this.uiFrame.tlm());
                break;
            }
            case 19: {
                this.tlm = new mainboardAllScience((Uvsqsat.MainboardAllScience)this.uiFrame.tlm());
                break;
            }
            case 20: {
                this.tlm = new mainboardHk((Uvsqsat.MainboardHk)this.uiFrame.tlm());
                break;
            }
            case 21: {
                this.tlm = new iepsHkStatus((Uvsqsat.IepsHkStatus)this.uiFrame.tlm());
                break;
            }
            case 22: {
                this.tlm = new trxvurxHk((Uvsqsat.TrxvurxHk)this.uiFrame.tlm());
                break;
            }
            case 23: {
                this.tlm = new imtqHk((Uvsqsat.ImtqHk)this.uiFrame.tlm());
                break;
            }
            case 24: {
                this.tlm = new trxvutxHk((Uvsqsat.TrxvutxHk)this.uiFrame.tlm());
                break;
            }
            default: {
                appLogger.severe("SID not found " + this.sid);
                this.tlm = new msgOrUnknow((Uvsqsat.MsgOrUnknow)this.uiFrame.tlm());
            }
        }
    }

    public String toString() {
        return this.ax25.toStringHeader() + this.separator + this.packetPrimaryHeader.toString() + this.separator + this.packetSecondaryHeader.toString() + this.separator + this.tlm.toStringRaw() + this.separator + this.tlm.toStringCompute();
    }

    public String toStringFormat() {
        return "###############################################################" + this.separator + "AX25 HEADER" + this.separator + this.ax25.toStringHeader() + "===============================================================" + this.separator + "HEADERS" + this.separator + "===============================================================" + this.separator + this.packetPrimaryHeader.toString() + this.separator + this.packetSecondaryHeader.toString() + this.separator + this.separator + "===============================================================" + this.separator + "COMPUTE DATA" + this.separator + this.tlm.toStringCompute() + this.separator + "###############################################################" + this.separator;
    }

    public int getSid() {
        return this.sid;
    }

    public void setSid(int sid) {
        this.sid = sid;
    }

    public PPrimaryHeader getPacketPrimaryHeader() {
        return this.packetPrimaryHeader;
    }

    public PSecondaryHeader getPacketSecondaryHeader() {
        return this.packetSecondaryHeader;
    }

    public Uvsqsat.UiFrame getUiFrame() {
        return this.uiFrame;
    }
}

