/*
 * Decompiled with CFR 0.152.
 */
package org.josast.ModuleSoundModem;

import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.josast.AX25.AX25Frame;
import org.josast.AX25.KissData;
import org.josast.AX25.KissFrame;
import org.josast.ModuleSoundModem.KissException;
import org.josast.ModuleSoundModem.SoundModemConfiguration;
import org.josast.ModuleSoundModem.kiss;

public class SoundModemClient {
    private Logger log = Logger.getLogger("AmsatLogger");
    private SoundModemConfiguration smConfiguration = null;
    private Socket skt = null;
    private InputStream in = null;
    private boolean open = false;
    private int bufferSize = 1024;
    private Path filepath;

    public SoundModemClient() {
        this.smConfiguration = new SoundModemConfiguration("defaultConfigFile.ini");
        this.openSocket();
        this.initialiseFile();
    }

    public SoundModemClient(SoundModemConfiguration smConfig) {
        this.smConfiguration = smConfig;
        this.openSocket();
        this.initialiseFile();
    }

    public SoundModemClient(String filename) {
        this.smConfiguration = new SoundModemConfiguration(filename);
        this.openSocket();
        this.initialiseFile();
    }

    private void openSocket() {
        try {
            this.skt = new Socket(this.smConfiguration.getSmIPadress(), this.smConfiguration.getSmPort());
            this.in = this.skt.getInputStream();
            this.open = true;
        }
        catch (IOException e) {
            this.log.log(Level.SEVERE, "create stream " + e.toString());
            this.open = false;
        }
    }

    private void initialiseFile() {
        if (this.smConfiguration.isSmGenerateBinarieFile()) {
            Path path = Paths.get(this.smConfiguration.getSmBinarieOutputDirectory(), new String[0]);
            if (!Files.exists(path, new LinkOption[0])) {
                try {
                    Files.createDirectories(path, new FileAttribute[0]);
                }
                catch (IOException e) {
                    this.log.log(Level.SEVERE, "cannot create outpout directorie " + e.toString());
                }
            }
            String creationdate = "";
            if (this.smConfiguration.isSmBinarieFilePrefixDate()) {
                SimpleDateFormat formater = new SimpleDateFormat("yyyy-MM-dd-HHmmss");
                Date aujourdhui = new Date();
                creationdate = formater.format(aujourdhui) + "-";
            }
            this.filepath = Paths.get(this.smConfiguration.getSmBinarieOutputDirectory() + "\\" + creationdate + this.smConfiguration.getSmBinarieOutputFile(), new String[0]);
            byte[] temp = new byte[]{};
            try {
                Files.write(this.filepath, temp, new OpenOption[0]);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public byte[] receivedKissData() {
        byte[] cbuf = new byte[this.bufferSize];
        int nbbyteread = 0;
        if (!this.open) {
            this.log.severe("Connection not open, return null");
            return null;
        }
        try {
            nbbyteread = this.in.read(cbuf);
        }
        catch (IOException e) {
            this.log.log(Level.SEVERE, "Error Read data " + e.toString());
            try {
                this.in.close();
            }
            catch (IOException e1) {
                this.log.log(Level.SEVERE, "Closing " + e1.toString());
            }
        }
        byte[] temp = Arrays.copyOf(cbuf, nbbyteread);
        if (this.smConfiguration.isSmGenerateBinarieFile()) {
            try {
                Files.write(this.filepath, temp, StandardOpenOption.APPEND);
            }
            catch (IOException e) {
                this.log.severe(e.toString());
            }
        }
        return Arrays.copyOf(cbuf, nbbyteread);
    }

    @Deprecated
    public int receiveData(byte[] cbuf) {
        try {
            return this.in.read(cbuf);
        }
        catch (IOException e) {
            this.log.log(Level.SEVERE, "Error Read data " + e.toString());
            try {
                this.in.close();
            }
            catch (IOException e1) {
                this.log.log(Level.SEVERE, "Closing " + e1.toString());
            }
            return 0;
        }
    }

    @Deprecated
    public AX25Frame decode(byte[] frame, int nb) {
        KissFrame kf = new KissFrame();
        KissData kissData = kf.extactMessage(frame, nb);
        AX25Frame ax = new AX25Frame();
        ax.decodeAX25Frame(kissData.getData(), kissData.getSize());
        System.out.println(kissData.toString());
        System.out.println(ax.toString());
        return ax;
    }

    public void close() {
        try {
            this.in.close();
        }
        catch (IOException e1) {
            this.log.log(Level.SEVERE, "Closing " + e1.toString());
        }
    }

    public boolean isOpen() {
        return this.open;
    }

    public byte[] receivedRawData() {
        byte[] temp = this.receivedKissData();
        if (temp == null) {
            this.log.severe("Buffer read null, return null");
            return null;
        }
        kiss k = new kiss(temp);
        try {
            temp = k.toRaw();
        }
        catch (KissException e) {
            this.log.log(Level.SEVERE, "Extract Raw data " + e.toString());
        }
        return temp;
    }
}

