/*
 * Decompiled with CFR 0.152.
 */
package org.josast.UVSQsatDecoder;

import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import javafx.application.Platform;
import javafx.concurrent.WorkerStateEvent;
import javafx.embed.swing.SwingFXUtils;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.control.Tab;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.image.ImageView;
import javafx.scene.image.WritableImage;
import javafx.scene.layout.VBox;
import javafx.scene.web.WebEngine;
import javafx.scene.web.WebView;
import javafx.stage.Stage;
import javafx.stage.Window;
import javax.imageio.ImageIO;
import org.josast.ModuleSoundModem.SoundModemConfiguration;
import org.josast.SIDS.Station;
import org.josast.UVSQsatDecoder.Ax25Display;
import org.josast.UVSQsatDecoder.Configuration;
import org.josast.UVSQsatDecoder.DisplayUVSQsat;
import org.josast.UVSQsatDecoder.ModelReceivedData;
import org.josast.UVSQsatDecoder.ReceivedData;
import org.josast.UVSQsatDecoder.SendSIDS;
import org.josast.UVSQsatDecoder.TaskSoundmodemTCP;
import org.josast.UVSQsatDecoder.util.LogFile;
import org.josast.javafx.AlertHelper;
import org.josast.propertyHttp.ConfigHttp;
import org.josast.uvsqsat.Frame;
import org.josast.uvsqsat.generated.Uvsqsat;

public class Controler {
    private static Logger appLogger = Logger.getLogger("AmsatLogger");
    private int delayRefresh = 6;
    private LogFile logfile = null;
    private static final String LINE_SEPARATOR = "\r\n";
    private static final int STATE_INIT = 0;
    private static final int STATE_START = 1;
    protected static final int STATE_STOP = 2;
    private static final int STATE_SAVE = 3;
    private Ax25Display ax25display = new Ax25Display();
    private DisplayUVSQsat displayUVSQsat = new DisplayUVSQsat();
    ModelReceivedData receivedFrame = new ModelReceivedData();
    private TaskSoundmodemTCP task;
    private SendSIDS SendSIDSSatnogs;
    private SendSIDS SendSIDSMVPAmsat;
    private String imgAmsat = "logoAmsat.png";
    private String imgSatellite = "OIP.jpg";
    Station station = new Station();
    Configuration conf = Configuration.getInstance();
    private String version = "0.6";
    @FXML
    private TextArea DecodedData;
    @FXML
    private Label LabelFrame;
    @FXML
    private Label LabelInformation;
    @FXML
    private Button ButtonStart;
    @FXML
    private Button ButtonStop;
    @FXML
    private Button ButtonSave;
    @FXML
    private Button ButtonSaveConfiguration;
    @FXML
    private TextArea TextAreaMessage;
    @FXML
    private Label labelStatus;
    @FXML
    private TextArea TexAreaLog;
    @FXML
    private TextField TextFieldCallsign;
    @FXML
    private TextField TextFieldLatitude;
    @FXML
    private TextField TextFieldLongitude;
    @FXML
    private CheckBox CheckboxAmsatFDatabase;
    @FXML
    private CheckBox CheckBoxSatNogs;
    @FXML
    private TextField TextFieldSIDSEntrysat;
    @FXML
    private TextField TextFieldSIDSSatnogs;
    @FXML
    private TextField FieldIP;
    @FXML
    private TextField FieldPort;
    @FXML
    private ImageView ImageViewAMSAT;
    @FXML
    private ImageView imageViewSatellite;
    @FXML
    private WebView WebViewInfo;
    @FXML
    private VBox VboxInfo;
    @FXML
    private TextField tfDateCurrent;
    @FXML
    private TextField tfFrameSid;
    @FXML
    private TextField tfFrameName;
    private Stage primaryStage = null;
    @FXML
    private TextField tfsideAAntsTemperatureRaw;
    @FXML
    private TextField tfsideAAntsDeploymentStatusRaw;
    @FXML
    private TextField tfsideAAntsUptimeRaw;
    @FXML
    private TextField tfsideADeploymentCountAntenna1Raw;
    @FXML
    private TextField tfsideADeploymentCountAntenna2Raw;
    @FXML
    private TextField tfsideADeploymentCountAntenna3Raw;
    @FXML
    private TextField tfsideADeploymentCountAntenna4Raw;
    @FXML
    private TextField tfsideADeploymentTimeAntenna1Raw;
    @FXML
    private TextField tfsideADeploymentTimeAntenna2Raw;
    @FXML
    private TextField tfsideADeploymentTimeAntenna3Raw;
    @FXML
    private TextField tfsideADeploymentTimeAntenna4Raw;
    @FXML
    private TextField tfsideBAntsTemperatureRaw;
    @FXML
    private TextField tfsideBAntsDeploymentStatusRaw;
    @FXML
    private TextField tfsideBAntsUptimeRaw;
    @FXML
    private TextField tfsideBDeploymentCountAntenna1Raw;
    @FXML
    private TextField tfsideBDeploymentCountAntenna2Raw;
    @FXML
    private TextField tfsideBDeploymentCountAntenna3Raw;
    @FXML
    private TextField tfsideBDeploymentCountAntenna4Raw;
    @FXML
    private TextField tfsideBDeploymentTimeAntenna1Raw;
    @FXML
    private TextField tfsideBDeploymentTimeAntenna2Raw;
    @FXML
    private TextField tfsideBDeploymentTimeAntenna3Raw;
    @FXML
    private TextField tfsideBDeploymentTimeAntenna4Raw;
    @FXML
    private TextField tfswModeRaw;
    @FXML
    private TextField tfresetOrderRaw;
    @FXML
    private TextField tfformatSdcardOrderRaw;
    @FXML
    private TextField tfnbTcPingSinceFirstStartRaw;
    @FXML
    private TextField tfhKStidRaw;
    @FXML
    private TextField tfhKIvidRaw;
    @FXML
    private TextField tfhKRcRaw;
    @FXML
    private TextField tfhKBidRaw;
    @FXML
    private TextField tfhKCmderrRaw;
    @FXML
    private TextField tfhKStatRaw;
    @FXML
    private TextField tfvoltBrdSupRawV;
    @FXML
    private TextField tftempRawT;
    @FXML
    private TextField tfvDistInputRawV;
    @FXML
    private TextField tfiDistInputRawMa;
    @FXML
    private TextField tfpDistInputRawMw;
    @FXML
    private TextField tfvBattInputRawV;
    @FXML
    private TextField tfiBattInputRawMa;
    @FXML
    private TextField tfpBattInputRawMw;
    @FXML
    private TextField tfstatObcOnRaw;
    @FXML
    private TextField tfstatObcOcfRaw;
    @FXML
    private TextField tfbatStatRaw;
    @FXML
    private TextField tfbatTemp2RawT;
    @FXML
    private TextField tfvoltVd0Raw;
    @FXML
    private TextField tfvoltVd1Raw;
    @FXML
    private TextField tfvoltVd2Raw;
    @FXML
    private TextField tfvObc00V;
    @FXML
    private TextField tfiObc00Ma;
    @FXML
    private TextField tfpObc00Mw;
    @FXML
    private TextField tfvObc01V;
    @FXML
    private TextField tfiObc01Ma;
    @FXML
    private TextField tfpObc01Mw;
    @FXML
    private TextField tfvObc02V;
    @FXML
    private TextField tfiObc02Ma;
    @FXML
    private TextField tfpObc02Mw;
    @FXML
    private TextField tfvObc03V;
    @FXML
    private TextField tfiObc03Ma;
    @FXML
    private TextField tfpObc03Mw;
    @FXML
    private TextField tfvObc05V;
    @FXML
    private TextField tfiObc05Ma;
    @FXML
    private TextField tfpObc05Mw;
    @FXML
    private TextField tfvObc06V;
    @FXML
    private TextField tfiObc06Ma;
    @FXML
    private TextField tfpObc06Mw;
    @FXML
    private TextField tfcc1Byte;
    @FXML
    private TextField tfcc2Byte;
    @FXML
    private TextField tfcc3Byte;
    @FXML
    private TextField tfstatusStidRaw;
    @FXML
    private TextField tfstatusIvidRaw;
    @FXML
    private TextField tfstatusRcRaw;
    @FXML
    private TextField tfstatusBidRaw;
    @FXML
    private TextField tfstatusCmderrRaw;
    @FXML
    private TextField tfstatusStatRaw;
    @FXML
    private TextField tfmodeRaw;
    @FXML
    private TextField tfconfRaw;
    @FXML
    private TextField tfresetCauseRaw;
    @FXML
    private TextField tfuptimeRaw;
    @FXML
    private TextField tferrorRaw;
    @FXML
    private TextField tfrcCntPwronRaw;
    @FXML
    private TextField tfrcCntWdgRaw;
    @FXML
    private TextField tfrcCntCmdRaw;
    @FXML
    private TextField tfrcCntMcuRaw;
    @FXML
    private TextField tfrcCntEmlopoRaw;
    @FXML
    private TextField tfprevcmdElapsedRaw;
    @FXML
    private TextField tfdigitaleVoltageV;
    @FXML
    private TextField tfanalogVoltageV;
    @FXML
    private TextField tfdigitalCurrentRaw;
    @FXML
    private TextField tfanalogCurrentRaw;
    @FXML
    private TextField tfmeasureCoilXCurrentMa;
    @FXML
    private TextField tfmeasureCoilYCurrentMa;
    @FXML
    private TextField tfmeasureCoilZCurrentMa;
    @FXML
    private TextField tfmeasureCoilXTemperatureC;
    @FXML
    private TextField tfmeasureCoilYTemperatureC;
    @FXML
    private TextField tfmeasureCoilZTemperatureC;
    @FXML
    private TextField tfmcuTemperatureC;
    @FXML
    private TextField tfimtqSystemStateModeRaw;
    @FXML
    private TextField tfimtqSystemStateErrorRaw;
    @FXML
    private TextField tfimtqSystemStateConfigurationRaw;
    @FXML
    private TextField tfimtqSystemStateUptimeRaw;
    @FXML
    private TextField tfmainboardScienceTimeRaw;
    @FXML
    private TextField tfteachWearOnRaw;
    @FXML
    private TextField tffrequenceOfAcquisitionsRaw;
    @FXML
    private TextField tfgainRaw;
    @FXML
    private TextField tfnumberOfAcquisitionCommandedRaw;
    @FXML
    private TextField tfnumberOfRealAcquisitionRaw;
    @FXML
    private TextField tfhkPlus5vRaw;
    @FXML
    private TextField tfhkMinus5vRaw;
    @FXML
    private TextField tfhkMinus5vPolarRaw;
    @FXML
    private TextField tfhkTempAdcRaw;
    @FXML
    private TextField tfhkFeePlusXVrefRaw;
    @FXML
    private TextField tfhkFeeMinusXVrefRaw;
    @FXML
    private TextField tfhkFeePlusYVrefRaw;
    @FXML
    private TextField tfhkFeeMinusYVrefRaw;
    @FXML
    private TextField tffeePlusXErs1SignalRaw;
    @FXML
    private TextField tffeePlusXErs1TemperatureRaw;
    @FXML
    private TextField tffeePlusXErs2SignalRaw;
    @FXML
    private TextField tffeePlusXErs2TemperatureRaw;
    @FXML
    private TextField tffeePlusXErs3SignalRaw;
    @FXML
    private TextField tffeePlusXErs3TemperatureRaw;
    @FXML
    private TextField tffeePlusXUvsSignalRaw;
    @FXML
    private TextField tffeeMinusXErs1SignalRaw;
    @FXML
    private TextField tffeeMinusXErs1TemperatureRaw;
    @FXML
    private TextField tffeeMinusXErs2SignalRaw;
    @FXML
    private TextField tffeeMinusXErs2TemperatureRaw;
    @FXML
    private TextField tffeeMinusXErs3SignalRaw;
    @FXML
    private TextField tffeeMinusXErs3TemperatureRaw;
    @FXML
    private TextField tffeeMinusXUvsSignalRaw;
    @FXML
    private TextField tffeePlusYErs1SignalRaw;
    @FXML
    private TextField tffeePlusYErs1TemperatureRaw;
    @FXML
    private TextField tffeePlusYErs2SignalRaw;
    @FXML
    private TextField tffeePlusYErs2TemperatureRaw;
    @FXML
    private TextField tffeePlusYErs3SignalRaw;
    @FXML
    private TextField tffeePlusYErs3TemperatureRaw;
    @FXML
    private TextField tffeePlusYUvsSignalRaw;
    @FXML
    private TextField tffeeMinusYErs1SignalRaw;
    @FXML
    private TextField tffeeMinusYErs1TemperatureRaw;
    @FXML
    private TextField tffeeMinusYErs2SignalRaw;
    @FXML
    private TextField tffeeMinusYErs2TemperatureRaw;
    @FXML
    private TextField tffeeMinusYErs3SignalRaw;
    @FXML
    private TextField tffeeMinusYErs3TemperatureRaw;
    @FXML
    private TextField tffeeMinusYUvsSignalRaw;
    @FXML
    private TextField tfteachwearAccXRaw;
    @FXML
    private TextField tfteachwearAccYRaw;
    @FXML
    private TextField tfteachwearAccZRaw;
    @FXML
    private TextField tfteachwearDegCRaw;
    @FXML
    private TextField tfteachwearGyroXRaw;
    @FXML
    private TextField tfteachwearGyroYRaw;
    @FXML
    private TextField tfteachwearGyroZRaw;
    @FXML
    private TextField tfteachwearMagnXRaw;
    @FXML
    private TextField tfteachwearMagnYRaw;
    @FXML
    private TextField tfteachwearMagnZRaw;
    @FXML
    private TextField tfteachwearStateRaw;
    @FXML
    private TextField tfteachwearResetReasonRaw;
    @FXML
    private TextField tfteachwearCRCRaw;
    @FXML
    private TextField tfnbTmSinceFirstStartRaw;
    @FXML
    private TextField tfmainboardHKTimeRaw;
    @FXML
    private TextField tfhkPlus5VRaw;
    @FXML
    private TextField tfhkMinus5VRaw;
    @FXML
    private TextField tfhkMinusPolarRaw;
    @FXML
    private TextField tfhkTempADCRaw;
    @FXML
    private TextField tfdummyRaw;
    @FXML
    private TextField tfsupervisorEnableStatusRaw;
    @FXML
    private TextField tfsupervisorUptimeRaw;
    @FXML
    private TextField tfiobcResetCountRaw;
    @FXML
    private TextField tfiobcUptimeRaw;
    @FXML
    private TextField tfiobcMeasureTemperatureRaw;
    @FXML
    private TextField tfiobcMeasure3v3InRaw;
    @FXML
    private TextField tfiobcMeasure3v3Raw;
    @FXML
    private TextField tfiobcMeasure2vReferenceRaw;
    @FXML
    private TextField tfiobcMeasure1v8Raw;
    @FXML
    private TextField tfiobcMeasure1v0Raw;
    @FXML
    private TextField tfiobcMeasureCurrent3v3Raw;
    @FXML
    private TextField tfiobcMeasureCurrent1v8Raw;
    @FXML
    private TextField tfiobcMeasureCurrent1v0Raw;
    @FXML
    private TextField tfiobcMeasureVoltRtcRaw;
    @FXML
    private TextField tfiobcAdcUpdateFlagRaw;
    @FXML
    private TextField tfiobcCrc8Raw;
    @FXML
    private TextField tfphotodiode1Raw;
    @FXML
    private TextField tfphotodiode2Raw;
    @FXML
    private TextField tfphotodiode3Raw;
    @FXML
    private TextField tfphotodiode4Raw;
    @FXML
    private TextField tfphotodiode5Raw;
    @FXML
    private TextField tfphotodiode6Raw;
    @FXML
    private TextField tfpanelTemperature1C;
    @FXML
    private TextField tfpanelTemperature2C;
    @FXML
    private TextField tfpanelTemperature3C;
    @FXML
    private TextField tfpanelTemperature4C;
    @FXML
    private TextField tfpanelTemperature5C;
    @FXML
    private TextField tfpanelTemperature6C;
    @FXML
    private TextField tfdummydummy;
    @FXML
    private TextField tfspiCommandStatusRaw;
    @FXML
    private TextField tfsupervisorIndexOfSubsystemRaw;
    @FXML
    private TextField tfsupervisorMajorVersionRaw;
    @FXML
    private TextField tfsupervisorMinorVersionRaw;
    @FXML
    private TextField tfsupervisorPatchVersionRaw;
    @FXML
    private TextField tfsupervisorGitHeadVersionRaw;
    @FXML
    private TextField tfsupervisorSerialNumberRaw;
    @FXML
    private TextField tfcompilationInformationByte;
    @FXML
    private TextField tfclockSpeedRaw;
    @FXML
    private TextField tfcodeTypeRaw;
    @FXML
    private TextField tfcrc8Raw;
    @FXML
    private TextField tfswMmodeRaw;
    @FXML
    private TextField tflastResetReasonRaw;
    @FXML
    private TextField tfreservedRaw;
    @FXML
    private TextField tfnbResetRaw;
    @FXML
    private TextField tfreserved2Raw;
    @FXML
    private TextField tfdeployAntennasSystemRaw;
    @FXML
    private TextField tfnbTcSinceFirstStartRaw;
    @FXML
    private TextField tfnbBadTcSinceFirstStartRaw;
    @FXML
    private TextField tfnbTmInSdcardRaw;
    @FXML
    private TextField tfsdcardStatusRaw;
    @FXML
    private TextField tfsdcardLastErrorRaw;
    @FXML
    private TextField tfoldTimeTMInSdcardRaw;
    @FXML
    private TextField tfnewTimeTMInSdcardRaw;
    @FXML
    private TextField tftrxvurxInstantaneousReceivedSignalDopplerHz;
    @FXML
    private TextField tftrxvurxInstantaneousReceivedSignalStrengthDbm;
    @FXML
    private TextField tftrxvurxSupplyVoltageV;
    @FXML
    private TextField tftrxvurxTotalSupplyCurrentMa;
    @FXML
    private TextField tftrxvurxTransmitterCurrentMa;
    @FXML
    private TextField tftrxvurxReceiverCurrentMa;
    @FXML
    private TextField tftrxvurxPowerAmplifierCurrentMa;
    @FXML
    private TextField tftrxvurxPowerAmplifierTemperatureC;
    @FXML
    private TextField tftrxvurxLocalOscillatorTemperatureC;
    @FXML
    private TextField tftrxvurxZeroPaddingRaw;
    @FXML
    private TextField tftrxvuRxUptimeRaw;
    @FXML
    private TextField tftrxvutxInstantaneousRfReflectedPowerFromTransmitterPortMw;
    @FXML
    private TextField tftrxvutxInstantaneousRfForwardPowerFromTransmitterPortMw;
    @FXML
    private TextField tftrxvutxSupplyVoltageV;
    @FXML
    private TextField tftrxvutxTotalSupplyCurrentMa;
    @FXML
    private TextField tftrxvutxTransmitterCurrentMa;
    @FXML
    private TextField tftrxvutxReceiverCurrentMa;
    @FXML
    private TextField tftrxvutxPowerAmplifierCurrentMa;
    @FXML
    private TextField tftrxvutxPowerAmplifierTemperatureC;
    @FXML
    private TextField tftrxvutxLocalOscillatorTemperatureC;
    @FXML
    private TextField tftrxvutxZeroPaddingRaw;
    @FXML
    private TextField tftrxvuTxUptimeRaw;
    @FXML
    private TextField tftrxvuTxStateRaw;
    @FXML
    private Tab TabDataSream;
    @FXML
    private Tab infoTab;
    ScheduledExecutorService ses = Executors.newScheduledThreadPool(1);
    private ScheduledFuture<?> scheduledFuture = null;

    private void setupDataStream() {
        ReceivedData decodedData = this.receivedFrame.getLastReceivedData();
        if (decodedData != null) {
            this.DecodedData.clear();
            this.ax25display.setdata(decodedData);
            if (this.ax25display.GetCallsignFrom().contains("LATMOS")) {
                this.displayUVSQsat.setData(decodedData);
                Frame frame = this.displayUVSQsat.getFrame();
                if (frame != null) {
                    this.DecodedData.appendText(this.displayUVSQsat.getData());
                } else {
                    this.DecodedData.appendText(this.ax25display.getDisplay());
                }
                Object var2_2 = null;
            } else {
                this.DecodedData.appendText(this.ax25display.getDisplay());
            }
        } else {
            this.DecodedData.setText("No Value to display");
        }
    }

    @FXML
    private void HandleTabDataSreamChange() {
        Platform.runLater(new Runnable(){

            @Override
            public void run() {
                if (Controler.this.TabDataSream.isSelected()) {
                    Controler.this.setupDataStream();
                }
            }
        });
    }

    @FXML
    private void HandleIP(ActionEvent event) {
    }

    @FXML
    private void HandlePort(ActionEvent event) {
    }

    @FXML
    private void handleStart(ActionEvent event) {
        this.manageStatusinformation("Connected to modem", "Connection to modem");
        this.manageStateMMI(1);
        SoundModemConfiguration smc = new SoundModemConfiguration("configuration.ini");
        smc.setSmIPadress(this.FieldIP.getText());
        smc.setSmPort(Integer.parseInt(this.FieldPort.getText()));
        if (this.task == null) {
            this.receivedFrame.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    Platform.runLater(new Runnable(){

                        @Override
                        public void run() {
                            ReceivedData decodedData = Controler.this.receivedFrame.getLastReceivedData();
                            try {
                                if (decodedData != null) {
                                    Controler.this.updateFrame(Controler.this.receivedFrame.getNumberFrame());
                                    Controler.this.ax25display.setdata(decodedData);
                                    if (Controler.this.ax25display.GetCallsignFrom().contains("LATMOS")) {
                                        Controler.this.SendSids(decodedData);
                                        Controler.this.displayUVSQsat.setData(decodedData);
                                        Frame frame = Controler.this.displayUVSQsat.getFrame();
                                        if (frame != null) {
                                            String date = Controler.this.displayUVSQsat.getFrame().getPacketSecondaryHeader().getTime();
                                            Controler.this.tfDateCurrent.setText(date);
                                            int sid = Controler.this.displayUVSQsat.getFrame().getSid();
                                            Controler.this.tfFrameSid.setText("" + sid);
                                            if (Controler.this.TabDataSream.isSelected()) {
                                                Controler.this.DecodedData.appendText(Controler.this.displayUVSQsat.getData());
                                            }
                                            Controler.this.displayUvsqsat(sid, Controler.this.displayUVSQsat.getFrame().getUiFrame());
                                            Object var3_4 = null;
                                        } else {
                                            Controler.this.displayLog("Frame not reconized");
                                            Controler.this.ax25display.setdata(decodedData);
                                            Controler.this.displayLog(decodedData.toString());
                                            Controler.this.DecodedData.appendText(Controler.this.ax25display.getDisplay());
                                        }
                                        frame = null;
                                    } else {
                                        Controler.this.ax25display.setdata(decodedData);
                                        Controler.this.displayLog(decodedData.toString());
                                    }
                                } else {
                                    Controler.this.displayLog("received frame  : null");
                                }
                            }
                            catch (Exception e) {
                                Controler.this.displayLog("Run - error");
                                Controler.this.displayLog(e.toString());
                                e.printStackTrace();
                            }
                            decodedData = null;
                        }
                    });
                }
            });
        }
        this.task = new TaskSoundmodemTCP(smc, this.receivedFrame);
        this.task.setOnSucceeded(new EventHandler<WorkerStateEvent>(){

            @Override
            public void handle(WorkerStateEvent event) {
                Controler.this.manageStatusinformation("KISS TCP CONNECTION FAILED", "KISS TCP DISCONNECTED");
                Controler.this.manageStateMMI(2);
            }
        });
        this.task.setOnFailed(new EventHandler<WorkerStateEvent>(){

            @Override
            public void handle(WorkerStateEvent event) {
                Controler.this.manageStatusinformation("KISS TCP CONNECTION FAILED", "KISS TCP DISCONNECTED - Connection failed");
                Controler.this.displayLog(event.toString());
                Controler.this.displayLog(event.getSource().toString());
                Controler.this.manageStateMMI(2);
            }
        });
        Thread backgroundThread = new Thread(this.task);
        backgroundThread.setDaemon(true);
        backgroundThread.start();
    }

    @FXML
    private void handleStop(ActionEvent event) {
        this.manageStateMMI(2);
        this.task.arreter();
        this.manageStatusinformation("Stop received data", "Stop task to receive telemetrie");
    }

    @FXML
    private void handleSave(ActionEvent event) {
        this.manageStateMMI(3);
        this.manageStatusinformation("save data", "save Telemetry in file");
        this.saveDataFile();
        this.manageStatusinformation("Data Saved", "Telemetry Data saved in file");
    }

    @FXML
    private void HandleSaveConfiguration(ActionEvent event) {
        String erreurmsg = null;
        String Callsign2 = null;
        if (this.TextFieldCallsign.getText().isEmpty()) {
            erreurmsg = erreurmsg + "please enter a CallSign \r\n";
        } else {
            Callsign2 = this.TextFieldCallsign.getText();
        }
        String Latitude = this.TextFieldLatitude.getText();
        String Longitude = this.TextFieldLongitude.getText();
        if (!this.station.checkLatitude(Latitude)) {
            erreurmsg = erreurmsg + "Wrong format for Latitude : XX.XXE/W \r\n";
        }
        if (!this.station.checkLongitude(Longitude)) {
            erreurmsg = erreurmsg + "Wrong format for Longitude : XX.XXS/N \r\n";
        }
        if (erreurmsg != null) {
            Window owner = this.ButtonSaveConfiguration.getScene().getWindow();
            AlertHelper.showAlert(Alert.AlertType.ERROR, owner, "Form Error!", erreurmsg);
            return;
        }
        this.station.setCallsign(Callsign2);
        this.station.setLatitude(Latitude);
        this.station.setLongitude(Longitude);
        this.conf.setCallsign(Callsign2);
        this.conf.setLatitude(Latitude);
        this.conf.setLongitude(Longitude);
        this.conf.setSIDSAMSATSource(this.TextFieldSIDSEntrysat.getText());
        this.conf.setSIDSSatnogsSource(this.TextFieldSIDSSatnogs.getText());
        this.conf.setSoundModemIP(this.FieldIP.getText());
        this.conf.setSoundModemPort(this.FieldPort.getText());
        Station StationSatnogs = new Station(this.conf.getSIDSSatnogsSource(), this.station.getLongitude(), this.station.getLatitude());
        Station StationEntry = new Station(this.conf.getSIDSAMSATSource(), this.station.getLongitude(), this.station.getLatitude());
        if (this.CheckboxAmsatFDatabase.isSelected()) {
            this.conf.setSIDSAMSAT("1");
            this.SendSIDSMVPAmsat = new SendSIDS(StationEntry, this.conf.getNorad(), this.conf.getSIDSAMSATUrl());
        } else {
            this.conf.setSIDSAMSAT("0");
        }
        if (this.CheckBoxSatNogs.isSelected()) {
            this.conf.setSIDSSatnogs("1");
            this.SendSIDSSatnogs = new SendSIDS(StationSatnogs, this.conf.getNorad(), this.conf.getSIDSSatnogsURL());
        } else {
            this.conf.setSIDSSatnogs("0");
        }
        this.conf.save();
        this.manageStatusinformation("Configuration Saved", "Configuration Saved");
    }

    public void updateDistantconfiguration() {
        String message;
        String ver;
        int NoradIdConf = this.conf.getNorad();
        ConfigHttp c = new ConfigHttp("http://site.amsat-f.org/download/117652/");
        if (c.isConnected()) {
            ver = c.GetProperty("UVSQSatDecoder");
            message = c.GetProperty("Message");
            String noradid = c.GetProperty("NoradID");
            if (noradid != null) {
                NoradIdConf = Integer.parseUnsignedInt(c.GetProperty("NoradID").trim());
            }
        } else {
            ver = this.version;
            message = "not connected to internet";
        }
        if (NoradIdConf != 0 && NoradIdConf != this.conf.getNorad()) {
            this.conf.setNorad(NoradIdConf);
            this.conf.save();
            this.SendSIDSSatnogs.setNorad(NoradIdConf);
            this.SendSIDSMVPAmsat.setNorad(NoradIdConf);
            this.displayLog("Norad ID updated  ");
        }
        Object erreurmsg = !ver.equals(this.version) ? message + " New version " + ver + " available ! " : message;
        Platform.runLater(new Runnable(){
            final /* synthetic */ String val$erreurmsg;
            {
                this.val$erreurmsg = string;
            }

            @Override
            public void run() {
                Controler.this.LabelInformation.setText(this.val$erreurmsg);
                Controler.this.displayLog("information updated from internet");
            }
        });
    }

    public void setPrimaryStage(Stage stage) {
        this.primaryStage = this.primaryStage;
    }

    @FXML
    private void HandleInfoTabChange() {
        Platform.runLater(new Runnable(){

            @Override
            public void run() {
                if (Controler.this.infoTab.isSelected()) {
                    Controler.this.setupInfoTab();
                }
            }
        });
    }

    private void setupInfoTab() {
        File f = new File("./UVSQsatDecoderWithJREHelp.html");
        WebEngine engine = this.WebViewInfo.getEngine();
        if (f.exists()) {
            File file = new File(f.getAbsolutePath());
            URL url = null;
            try {
                url = file.toURI().toURL();
            }
            catch (MalformedURLException e) {
                appLogger.severe("Error to acces to " + f.getName());
            }
            engine.load(url.toString());
        } else {
            appLogger.severe(f.getName() + "Not Found");
        }
    }

    public void initMMI() {
        String message;
        String ver;
        this.setupInfoTab();
        Runnable task1 = () -> {
            appLogger.info("Distant Information update");
            this.updateDistantconfiguration();
        };
        this.scheduledFuture = this.ses.scheduleAtFixedRate(task1, this.delayRefresh, this.delayRefresh, TimeUnit.HOURS);
        this.logfile = new LogFile();
        ConfigHttp c = new ConfigHttp("http://site.amsat-f.org/download/117652/");
        this.manageStatusinformation("Initialised", "UVSQsat DECODER - LOG \r\n Initialise application");
        appLogger.warning("Initialise ");
        this.station.setCallsign(this.conf.getCallsign());
        this.station.setLatitude(this.conf.getLatitude());
        this.station.setLongitude(this.conf.getLongitude());
        this.TextFieldCallsign.setText(this.station.getCallsign());
        this.TextFieldLatitude.setText(this.station.getLatitude());
        this.TextFieldLongitude.setText(this.station.getLongitude());
        this.TextFieldSIDSEntrysat.setText(this.conf.getSIDSAMSATSource());
        this.TextFieldSIDSSatnogs.setText(this.conf.getSIDSSatnogsSource());
        this.FieldIP.setText(this.conf.getSoundModemIP());
        this.FieldPort.setText(this.conf.getSoundModemPort());
        if (this.conf.isSIDS_AMSAT()) {
            this.CheckboxAmsatFDatabase.setSelected(true);
        }
        if (this.conf.isSISD_SatNogs()) {
            this.CheckBoxSatNogs.setSelected(true);
        }
        this.displayLog(this.conf.getSIDSSatnogsURL());
        this.displayLog(this.conf.getSIDSAMSATUrl());
        this.displayLog("Initialisation with Properties File Done ");
        BufferedImage bufferedImage1 = null;
        BufferedImage bufferedImage2 = null;
        try {
            bufferedImage1 = ImageIO.read(this.getClass().getResource(this.imgAmsat));
            bufferedImage2 = ImageIO.read(this.getClass().getResource(this.imgSatellite));
        }
        catch (IOException e) {
            appLogger.severe("Error loading Image resources");
            appLogger.severe(e.toString());
        }
        WritableImage imageamsat = SwingFXUtils.toFXImage(bufferedImage1, null);
        this.ImageViewAMSAT.setImage(imageamsat);
        WritableImage imgQB = SwingFXUtils.toFXImage(bufferedImage2, null);
        this.imageViewSatellite.setImage(imgQB);
        int NoradIdConf = this.conf.getNorad();
        if (c.isConnected()) {
            ver = c.GetProperty("UVSQSatDecoder");
            message = c.GetProperty("Message");
            String noradid = c.GetProperty("NoradID");
            if (noradid != null) {
                NoradIdConf = Integer.parseUnsignedInt(c.GetProperty("NoradID").trim());
            }
        } else {
            ver = this.version;
            message = "not connected to internet";
        }
        if (NoradIdConf != 0 && NoradIdConf != this.conf.getNorad()) {
            this.conf.setNorad(NoradIdConf);
            this.conf.save();
            this.displayLog("Norad ID updated  ");
        }
        this.manageStateMMI(0);
        this.manageStatusinformation("Application Ready", "Application initialised");
        this.LabelInformation.setText("");
        Station StationSatnogs = new Station(this.conf.getSIDSSatnogsSource(), this.station.getLongitude(), this.station.getLatitude());
        Station StationEntry = new Station(this.conf.getSIDSAMSATSource(), this.station.getLongitude(), this.station.getLatitude());
        if (this.conf.isSISD_SatNogs()) {
            this.SendSIDSSatnogs = new SendSIDS(StationSatnogs, this.conf.getNorad(), this.conf.getSIDSSatnogsURL());
        }
        if (this.conf.isSIDS_AMSAT()) {
            this.SendSIDSMVPAmsat = new SendSIDS(StationEntry, this.conf.getNorad(), this.conf.getSIDSAMSATUrl());
        }
        Object erreurmsg = message;
        if (!ver.equals(this.version)) {
            erreurmsg = (String)erreurmsg + " New version " + ver + " available ! ";
        }
        this.LabelInformation.setText((String)erreurmsg);
    }

    private void manageStatusinformation(String statusMessage, String logMessage) {
        this.labelStatus.setText(statusMessage);
        this.displayLog(logMessage);
    }

    private void displayLog(String log) {
        appLogger.info(log);
        this.logfile.displayLog(log);
        this.TexAreaLog.appendText(log);
        this.TexAreaLog.appendText(LINE_SEPARATOR);
    }

    private void manageStateMMI(int state) {
        switch (state) {
            case 0: {
                this.ButtonStop.setDisable(true);
                this.ButtonStart.setDisable(false);
                this.ButtonSave.setDisable(true);
                break;
            }
            case 1: {
                this.ButtonStop.setDisable(false);
                this.ButtonStart.setDisable(true);
                this.ButtonSave.setDisable(false);
                break;
            }
            case 2: {
                this.ButtonStop.setDisable(true);
                this.ButtonStart.setDisable(false);
                this.ButtonSave.setDisable(false);
                break;
            }
            case 3: {
                this.ButtonStop.setDisable(true);
                this.ButtonStart.setDisable(false);
                this.ButtonSave.setDisable(true);
                break;
            }
            default: {
                this.ButtonStop.setDisable(true);
                this.ButtonStart.setDisable(false);
                this.ButtonSave.setDisable(false);
            }
        }
    }

    private void updateFrame(long nbframe) {
        this.LabelFrame.setText("frame : " + nbframe);
    }

    private void SendSids(ReceivedData receivedData) {
        int results;
        if (this.conf.isSIDS_AMSAT()) {
            results = this.SendSIDSMVPAmsat.Send(receivedData);
            this.displayLog("Send SIDS AMSAT-F Database ; " + results);
        }
        if (this.conf.isSISD_SatNogs()) {
            results = this.SendSIDSSatnogs.Send(receivedData);
            this.displayLog("Send SIDS SatNogs Database : " + results);
        }
    }

    public void saveDataFile() {
        SimpleDateFormat formater = new SimpleDateFormat("yyyy-MM-dd-HHmmss");
        Date aujourdhui = new Date();
        String path = System.getProperty("user.dir") + "/data";
        File apath = new File(path);
        if (!apath.exists() && !apath.mkdir()) {
            appLogger.severe("fail to create " + path);
        }
        PrintWriter pw = null;
        long NbFrame = this.receivedFrame.getNumberFrame();
        try {
            pw = new PrintWriter(new FileWriter(path + "/" + formater.format(aujourdhui) + "-tlm-Hexa.txt"));
            int i = 0;
            while ((long)i < NbFrame) {
                pw.write(this.receivedFrame.getRawFrame(i));
                pw.write(LINE_SEPARATOR);
                ++i;
            }
            pw.flush();
            pw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void displayUvsqsat(int sid, Uvsqsat.UiFrame uiFrame2) {
        switch (sid) {
            case 14: {
                this.tfFrameName.setText("Message");
                this.allocateAmsatAscii((Uvsqsat.AmsatAscii)uiFrame2.tlm());
                break;
            }
            case 15: {
                this.tfFrameName.setText("Beacon");
                this.allocateBeacon((Uvsqsat.Beacon)uiFrame2.tlm());
                break;
            }
            case 16: {
                this.tfFrameName.setText("Ants HK");
                this.allocateAntsHk((Uvsqsat.AntsHk)uiFrame2.tlm());
                break;
            }
            case 17: {
                this.tfFrameName.setText("OBC status");
                this.allocateObcStatus((Uvsqsat.ObcStatus)uiFrame2.tlm());
                break;
            }
            case 18: {
                this.tfFrameName.setText("OBC HK");
                this.allocateObcHk((Uvsqsat.ObcHk)uiFrame2.tlm());
                break;
            }
            case 19: {
                this.tfFrameName.setText("Mainboard all science");
                this.allocateMainboardAllScience((Uvsqsat.MainboardAllScience)uiFrame2.tlm());
                break;
            }
            case 20: {
                this.tfFrameName.setText("Mainboard HK");
                this.allocateMainboardHk((Uvsqsat.MainboardHk)uiFrame2.tlm());
                break;
            }
            case 21: {
                this.tfFrameName.setText("Ieps HK status ");
                this.allocateIepsHkStatus((Uvsqsat.IepsHkStatus)uiFrame2.tlm());
                break;
            }
            case 22: {
                this.tfFrameName.setText("trxvurx HK");
                this.allocateTrxvurxHk((Uvsqsat.TrxvurxHk)uiFrame2.tlm());
                break;
            }
            case 23: {
                this.tfFrameName.setText("IMTQ HK");
                this.allocateImtqHk((Uvsqsat.ImtqHk)uiFrame2.tlm());
                break;
            }
            case 24: {
                this.tfFrameName.setText("Trxvutx HK");
                this.allocateTrxvutxHk((Uvsqsat.TrxvutxHk)uiFrame2.tlm());
                break;
            }
            default: {
                this.tfFrameName.setText("SID not found");
                System.err.println("SID not found " + sid);
            }
        }
    }

    private void allocateAmsatAscii(Uvsqsat.AmsatAscii tlm) {
        this.TextAreaMessage.setText(tlm.messageStr());
    }

    public String getversion() {
        return this.version;
    }

    private void allocateAntsHk(Uvsqsat.AntsHk o) {
        this.tfsideAAntsTemperatureRaw.setText("" + o.sideAAntsTemperatureRaw());
        this.tfsideAAntsDeploymentStatusRaw.setText("" + o.sideAAntsDeploymentStatusRaw());
        this.tfsideAAntsUptimeRaw.setText("" + o.sideAAntsUptimeRaw());
        this.tfsideADeploymentCountAntenna1Raw.setText("" + o.sideADeploymentCountAntenna1Raw());
        this.tfsideADeploymentCountAntenna2Raw.setText("" + o.sideADeploymentCountAntenna2Raw());
        this.tfsideADeploymentCountAntenna3Raw.setText("" + o.sideADeploymentCountAntenna3Raw());
        this.tfsideADeploymentCountAntenna4Raw.setText("" + o.sideADeploymentCountAntenna4Raw());
        this.tfsideADeploymentTimeAntenna1Raw.setText("" + o.sideADeploymentTimeAntenna1Raw());
        this.tfsideADeploymentTimeAntenna2Raw.setText("" + o.sideADeploymentTimeAntenna2Raw());
        this.tfsideADeploymentTimeAntenna3Raw.setText("" + o.sideADeploymentTimeAntenna3Raw());
        this.tfsideADeploymentTimeAntenna4Raw.setText("" + o.sideADeploymentTimeAntenna4Raw());
        this.tfsideBAntsTemperatureRaw.setText("" + o.sideBAntsTemperatureRaw());
        this.tfsideBAntsDeploymentStatusRaw.setText("" + o.sideBAntsDeploymentStatusRaw());
        this.tfsideBAntsUptimeRaw.setText("" + o.sideBAntsUptimeRaw());
        this.tfsideBDeploymentCountAntenna1Raw.setText("" + o.sideBDeploymentCountAntenna1Raw());
        this.tfsideBDeploymentCountAntenna2Raw.setText("" + o.sideBDeploymentCountAntenna2Raw());
        this.tfsideBDeploymentCountAntenna3Raw.setText("" + o.sideBDeploymentCountAntenna3Raw());
        this.tfsideBDeploymentCountAntenna4Raw.setText("" + o.sideBDeploymentCountAntenna4Raw());
        this.tfsideBDeploymentTimeAntenna1Raw.setText("" + o.sideBDeploymentTimeAntenna1Raw());
        this.tfsideBDeploymentTimeAntenna2Raw.setText("" + o.sideBDeploymentTimeAntenna2Raw());
        this.tfsideBDeploymentTimeAntenna3Raw.setText("" + o.sideBDeploymentTimeAntenna3Raw());
        this.tfsideBDeploymentTimeAntenna4Raw.setText("" + o.sideBDeploymentTimeAntenna4Raw());
    }

    private void allocateBeacon(Uvsqsat.Beacon o) {
        this.tfswModeRaw.setText(this.decodeSwMode(o.swModeRaw()));
        this.tflastResetReasonRaw.setText(this.decodelastResetReason(o.lastResetReasonRaw()));
        this.tfresetOrderRaw.setText(this.decodeResetOrder(o.resetOrderRaw()));
        this.tfnbResetRaw.setText("" + o.nbResetRaw());
        this.tfformatSdcardOrderRaw.setText("" + o.formatSdcardOrderRaw());
        this.tfdeployAntennasSystemRaw.setText("" + o.deployAntennasSystemRaw());
        this.tfnbTmSinceFirstStartRaw.setText("" + o.nbTmSinceFirstStartRaw());
        this.tfnbTcSinceFirstStartRaw.setText("" + o.nbTcSinceFirstStartRaw());
        this.tfnbTcPingSinceFirstStartRaw.setText("" + o.nbTcPingSinceFirstStartRaw());
        this.tfnbBadTcSinceFirstStartRaw.setText("" + o.nbBadTcSinceFirstStartRaw());
        this.tfnbTmInSdcardRaw.setText("" + o.nbTmInSdcardRaw());
        this.tftrxvutxInstantaneousRfReflectedPowerFromTransmitterPortMw.setText(String.format("%.3f", o.trxvutxInstantaneousRfReflectedPowerFromTransmitterPortMw()));
        this.tftrxvutxInstantaneousRfForwardPowerFromTransmitterPortMw.setText(String.format("%.3f", o.trxvutxInstantaneousRfForwardPowerFromTransmitterPortMw()));
        this.tftrxvutxSupplyVoltageV.setText(String.format("%.3f", o.trxvutxSupplyVoltageV()));
        this.tftrxvutxTotalSupplyCurrentMa.setText(String.format("%.3f", o.trxvutxTotalSupplyCurrentMa()));
        this.tftrxvutxTransmitterCurrentMa.setText(String.format("%.3f", o.trxvutxTransmitterCurrentMa()));
        this.tftrxvutxReceiverCurrentMa.setText(String.format("%.3f", o.trxvutxReceiverCurrentMa()));
        this.tftrxvutxPowerAmplifierCurrentMa.setText(String.format("%.3f", o.trxvutxPowerAmplifierCurrentMa()));
        this.tftrxvutxPowerAmplifierTemperatureC.setText(String.format("%.3f", o.trxvutxPowerAmplifierTemperatureC()));
        this.tftrxvutxLocalOscillatorTemperatureC.setText(String.format("%.3f", o.trxvutxLocalOscillatorTemperatureC()));
        this.tftrxvurxInstantaneousReceivedSignalDopplerHz.setText(String.format("%.3f", o.trxvurxInstantaneousReceivedSignalDopplerHz()));
        this.tftrxvurxInstantaneousReceivedSignalStrengthDbm.setText(String.format("%.3f", o.trxvurxInstantaneousReceivedSignalStrengthDbm()));
        this.tftrxvurxSupplyVoltageV.setText(String.format("%.3f", o.trxvurxSupplyVoltageV()));
        this.tftrxvurxTotalSupplyCurrentMa.setText(String.format("%.3f", o.trxvurxTotalSupplyCurrentMa()));
        this.tftrxvurxTransmitterCurrentMa.setText(String.format("%.3f", o.trxvurxTransmitterCurrentMa()));
        this.tftrxvurxReceiverCurrentMa.setText(String.format("%.3f", o.trxvurxReceiverCurrentMa()));
        this.tftrxvurxPowerAmplifierCurrentMa.setText(String.format("%.3f", o.trxvurxPowerAmplifierCurrentMa()));
        this.tftrxvurxPowerAmplifierTemperatureC.setText(String.format("%.3f", o.trxvurxPowerAmplifierTemperatureC()));
        this.tftrxvurxLocalOscillatorTemperatureC.setText(String.format("%.3f", o.trxvurxLocalOscillatorTemperatureC()));
        this.tfimtqSystemStateModeRaw.setText("" + o.imtqSystemStateModeRaw());
        this.tfmeasureCoilXCurrentMa.setText(String.format("%.3f", o.measureCoilXCurrentMa()));
        this.tfmeasureCoilYCurrentMa.setText(String.format("%.3f", o.measureCoilYCurrentMa()));
        this.tfmeasureCoilZCurrentMa.setText(String.format("%.3f", o.measureCoilZCurrentMa()));
        this.tfmeasureCoilXTemperatureC.setText(String.format("%.3f", o.measureCoilXTemperatureC()));
        this.tfmeasureCoilYTemperatureC.setText(String.format("%.3f", o.measureCoilYTemperatureC()));
        this.tfmeasureCoilZTemperatureC.setText(String.format("%.3f", o.measureCoilZTemperatureC()));
        this.tfmcuTemperatureC.setText(String.format("%.3f", o.mcuTemperatureC()));
        this.tfsideAAntsTemperatureRaw.setText("" + o.sideAAntsTemperatureRaw());
        this.tfsideAAntsDeploymentStatusRaw.setText("" + o.sideAAntsDeploymentStatusRaw());
        this.tfvoltBrdSupRawV.setText(String.format("%.3f", o.voltBrdSupRawV()));
        this.tftempRawT.setText(String.format("%.3f", o.tempRawT()));
        this.tfvDistInputRawV.setText(String.format("%.3f", o.vDistInputRawV()));
        this.tfiDistInputRawMa.setText(String.format("%.3f", o.iDistInputRawMa()));
        this.tfpDistInputRawMw.setText(String.format("%.3f", o.pDistInputRawMw()));
        this.tfvBattInputRawV.setText(String.format("%.3f", o.vBattInputRawV()));
        this.tfiBattInputRawMa.setText(String.format("%.3f", o.iBattInputRawMa()));
        this.tfpBattInputRawMw.setText(String.format("%.3f", o.pBattInputRawMw()));
        this.tfstatObcOnRaw.setText("" + o.statObcOnRaw());
        this.tfstatObcOcfRaw.setText("" + o.statObcOcfRaw());
        this.tfbatStatRaw.setText("" + o.batStatRaw());
        this.tfbatTemp2RawT.setText(String.format("%.3f", o.batTemp2RawT()));
        this.tfvoltVd0Raw.setText("" + o.voltVd0Raw());
        this.tfvoltVd1Raw.setText("" + o.voltVd1Raw());
        this.tfvoltVd2Raw.setText("" + o.voltVd2Raw());
        this.tfvObc00V.setText(String.format("%.3f", o.vObc00V()));
        this.tfiObc00Ma.setText(String.format("%.3f", o.iObc00Ma()));
        this.tfpObc00Mw.setText(String.format("%.3f", o.pObc00Mw()));
        this.tfvObc01V.setText(String.format("%.3f", o.vObc01V()));
        this.tfiObc01Ma.setText(String.format("%.3f", o.iObc01Ma()));
        this.tfpObc01Mw.setText(String.format("%.3f", o.pObc01Mw()));
        this.tfvObc02V.setText(String.format("%.3f", o.vObc02V()));
        this.tfiObc02Ma.setText(String.format("%.3f", o.iObc02Ma()));
        this.tfpObc02Mw.setText(String.format("%.3f", o.pObc02Mw()));
        this.tfvObc03V.setText(String.format("%.3f", o.vObc03V()));
        this.tfiObc03Ma.setText(String.format("%.3f", o.iObc03Ma()));
        this.tfpObc03Mw.setText(String.format("%.3f", o.pObc03Mw()));
        this.tfvObc05V.setText(String.format("%.3f", o.vObc05V()));
        this.tfiObc05Ma.setText(String.format("%.3f", o.iObc05Ma()));
        this.tfpObc05Mw.setText(String.format("%.3f", o.pObc05Mw()));
        this.tfvObc06V.setText(String.format("%.3f", o.vObc06V()));
        this.tfiObc06Ma.setText(String.format("%.3f", o.iObc06Ma()));
        this.tfpObc06Mw.setText(String.format("%.3f", o.pObc06Mw()));
        this.tfstatusStidRaw.setText("" + o.statusStidRaw());
        this.tfstatusIvidRaw.setText("" + o.statusIvidRaw());
        this.tfstatusRcRaw.setText("" + o.statusRcRaw());
        this.tfstatusBidRaw.setText("" + o.statusBidRaw());
        this.tfstatusCmderrRaw.setText("" + o.statusCmderrRaw());
        this.tfstatusStatRaw.setText("" + o.statusStatRaw());
        this.tfmodeRaw.setText("" + o.modeRaw());
        this.tfconfRaw.setText("" + o.confRaw());
        this.tfresetCauseRaw.setText("" + o.resetCauseRaw());
        this.tfuptimeRaw.setText("" + o.uptimeRaw());
        this.tferrorRaw.setText("" + o.errorRaw());
        this.tfrcCntPwronRaw.setText("" + o.rcCntPwronRaw());
        this.tfrcCntWdgRaw.setText("" + o.rcCntWdgRaw());
        this.tfrcCntCmdRaw.setText("" + o.rcCntCmdRaw());
        this.tfrcCntMcuRaw.setText("" + o.rcCntMcuRaw());
        this.tfrcCntEmlopoRaw.setText("" + o.rcCntEmlopoRaw());
        this.tfprevcmdElapsedRaw.setText("" + o.prevcmdElapsedRaw());
        this.tfphotodiode1Raw.setText("" + o.photodiode1Raw());
        this.tfphotodiode2Raw.setText("" + o.photodiode2Raw());
        this.tfphotodiode3Raw.setText("" + o.photodiode3Raw());
        this.tfphotodiode4Raw.setText("" + o.photodiode4Raw());
        this.tfphotodiode5Raw.setText("" + o.photodiode5Raw());
        this.tfphotodiode6Raw.setText("" + o.photodiode6Raw());
        this.tfpanelTemperature1C.setText(String.format("%.3f", o.panelTemperature1C()));
        this.tfpanelTemperature2C.setText(String.format("%.3f", o.panelTemperature2C()));
        this.tfpanelTemperature3C.setText(String.format("%.3f", o.panelTemperature3C()));
        this.tfpanelTemperature4C.setText(String.format("%.3f", o.panelTemperature4C()));
        this.tfpanelTemperature5C.setText(String.format("%.3f", o.panelTemperature5C()));
        this.tfpanelTemperature6C.setText(String.format("%.3f", o.panelTemperature6C()));
    }

    private void allocateIepsHkStatus(Uvsqsat.IepsHkStatus o) {
        this.tfhKStidRaw.setText("" + o.hKStidRaw());
        this.tfhKIvidRaw.setText("" + o.hKIvidRaw());
        this.tfhKRcRaw.setText("" + o.hKRcRaw());
        this.tfhKBidRaw.setText("" + o.hKBidRaw());
        this.tfhKCmderrRaw.setText("" + o.hKCmderrRaw());
        this.tfhKStatRaw.setText("" + o.hKStatRaw());
        this.tfvoltBrdSupRawV.setText(String.format("%.3f", o.voltBrdSupRawV()));
        this.tftempRawT.setText(String.format("%.3f", o.tempRawT()));
        this.tfvDistInputRawV.setText(String.format("%.3f", o.vDistInputRawV()));
        this.tfiDistInputRawMa.setText(String.format("%.3f", o.iDistInputRawMa()));
        this.tfpDistInputRawMw.setText(String.format("%.3f", o.pDistInputRawMw()));
        this.tfvBattInputRawV.setText(String.format("%.3f", o.vBattInputRawV()));
        this.tfiBattInputRawMa.setText(String.format("%.3f", o.iBattInputRawMa()));
        this.tfpBattInputRawMw.setText(String.format("%.3f", o.pBattInputRawMw()));
        this.tfstatObcOnRaw.setText("" + o.statObcOnRaw());
        this.tfstatObcOcfRaw.setText("" + o.statObcOcfRaw());
        this.tfbatStatRaw.setText("" + o.batStatRaw());
        this.tfbatTemp2RawT.setText(String.format("%.3f", o.batTemp2RawT()));
        this.tfvoltVd0Raw.setText("" + o.voltVd0Raw());
        this.tfvoltVd1Raw.setText("" + o.voltVd1Raw());
        this.tfvoltVd2Raw.setText("" + o.voltVd2Raw());
        this.tfvObc00V.setText(String.format("%.3f", o.vObc00V()));
        this.tfiObc00Ma.setText(String.format("%.3f", o.iObc00Ma()));
        this.tfpObc00Mw.setText(String.format("%.3f", o.pObc00Mw()));
        this.tfvObc01V.setText(String.format("%.3f", o.vObc01V()));
        this.tfiObc01Ma.setText(String.format("%.3f", o.iObc01Ma()));
        this.tfpObc01Mw.setText(String.format("%.3f", o.pObc01Mw()));
        this.tfvObc02V.setText(String.format("%.3f", o.vObc02V()));
        this.tfiObc02Ma.setText(String.format("%.3f", o.iObc02Ma()));
        this.tfpObc02Mw.setText(String.format("%.3f", o.pObc02Mw()));
        this.tfvObc03V.setText(String.format("%.3f", o.vObc03V()));
        this.tfiObc03Ma.setText(String.format("%.3f", o.iObc03Ma()));
        this.tfpObc03Mw.setText(String.format("%.3f", o.pObc03Mw()));
        this.tfvObc05V.setText(String.format("%.3f", o.vObc05V()));
        this.tfiObc05Ma.setText(String.format("%.3f", o.iObc05Ma()));
        this.tfpObc05Mw.setText(String.format("%.3f", o.pObc05Mw()));
        this.tfvObc06V.setText(String.format("%.3f", o.vObc06V()));
        this.tfiObc06Ma.setText(String.format("%.3f", o.iObc06Ma()));
        this.tfpObc06Mw.setText(String.format("%.3f", o.pObc06Mw()));
        this.tfcc1Byte.setText(this.toStringData(o.cc1Byte()));
        this.tfcc2Byte.setText(this.toStringData(o.cc2Byte()));
        this.tfcc3Byte.setText(this.toStringData(o.cc3Byte()));
        this.tfstatusStidRaw.setText("" + o.statusStidRaw());
        this.tfstatusIvidRaw.setText("" + o.statusIvidRaw());
        this.tfstatusRcRaw.setText("" + o.statusRcRaw());
        this.tfstatusBidRaw.setText("" + o.statusBidRaw());
        this.tfstatusCmderrRaw.setText("" + o.statusCmderrRaw());
        this.tfstatusStatRaw.setText("" + o.statusStatRaw());
        this.tfmodeRaw.setText("" + o.modeRaw());
        this.tfconfRaw.setText("" + o.confRaw());
        this.tfresetCauseRaw.setText("" + o.resetCauseRaw());
        this.tfuptimeRaw.setText("" + o.uptimeRaw());
        this.tferrorRaw.setText("" + o.errorRaw());
        this.tfrcCntPwronRaw.setText("" + o.rcCntPwronRaw());
        this.tfrcCntWdgRaw.setText("" + o.rcCntWdgRaw());
        this.tfrcCntCmdRaw.setText("" + o.rcCntCmdRaw());
        this.tfrcCntMcuRaw.setText("" + o.rcCntMcuRaw());
        this.tfrcCntEmlopoRaw.setText("" + o.rcCntEmlopoRaw());
        this.tfprevcmdElapsedRaw.setText("" + o.prevcmdElapsedRaw());
    }

    private void allocateImtqHk(Uvsqsat.ImtqHk o) {
        this.tfdigitaleVoltageV.setText(String.format("%.3f", o.digitaleVoltageV()));
        this.tfanalogVoltageV.setText(String.format("%.3f", o.analogVoltageV()));
        this.tfdigitalCurrentRaw.setText("" + o.digitalCurrentRaw());
        this.tfanalogCurrentRaw.setText("" + o.analogCurrentRaw());
        this.tfmeasureCoilXCurrentMa.setText(String.format("%.3f", o.measureCoilXCurrentMa()));
        this.tfmeasureCoilYCurrentMa.setText(String.format("%.3f", o.measureCoilYCurrentMa()));
        this.tfmeasureCoilZCurrentMa.setText(String.format("%.3f", o.measureCoilZCurrentMa()));
        this.tfmeasureCoilXTemperatureC.setText(String.format("%.3f", o.measureCoilXTemperatureC()));
        this.tfmeasureCoilYTemperatureC.setText(String.format("%.3f", o.measureCoilYTemperatureC()));
        this.tfmeasureCoilZTemperatureC.setText(String.format("%.3f", o.measureCoilZTemperatureC()));
        this.tfmcuTemperatureC.setText(String.format("%.3f", o.mcuTemperatureC()));
        this.tfimtqSystemStateModeRaw.setText("" + o.imtqSystemStateModeRaw());
        this.tfimtqSystemStateErrorRaw.setText("" + o.imtqSystemStateErrorRaw());
        this.tfimtqSystemStateConfigurationRaw.setText("" + o.imtqSystemStateConfigurationRaw());
        this.tfimtqSystemStateUptimeRaw.setText("" + o.imtqSystemStateUptimeRaw());
    }

    private void allocateMainboardAllScience(Uvsqsat.MainboardAllScience o) {
        this.tfmainboardScienceTimeRaw.setText("" + o.mainboardScienceTimeRaw());
        this.tfteachWearOnRaw.setText("" + o.teachWearOnRaw());
        this.tffrequenceOfAcquisitionsRaw.setText("" + o.frequenceOfAcquisitionsRaw());
        this.tfgainRaw.setText("" + o.gainRaw());
        this.tfnumberOfAcquisitionCommandedRaw.setText("" + o.numberOfAcquisitionCommandedRaw());
        this.tfnumberOfRealAcquisitionRaw.setText("" + o.numberOfRealAcquisitionRaw());
        this.tfhkPlus5vRaw.setText("" + o.hkPlus5vRaw());
        this.tfhkMinus5vRaw.setText("" + o.hkMinus5vRaw());
        this.tfhkMinus5vPolarRaw.setText("" + o.hkMinus5vPolarRaw());
        this.tfhkTempAdcRaw.setText("" + o.hkTempAdcRaw());
        this.tfhkFeePlusXVrefRaw.setText("" + o.hkFeePlusXVrefRaw());
        this.tfhkFeeMinusXVrefRaw.setText("" + o.hkFeeMinusXVrefRaw());
        this.tfhkFeePlusYVrefRaw.setText("" + o.hkFeePlusYVrefRaw());
        this.tfhkFeeMinusYVrefRaw.setText("" + o.hkFeeMinusYVrefRaw());
        this.tffeePlusXErs1SignalRaw.setText("" + o.feePlusXErs1SignalRaw());
        this.tffeePlusXErs1TemperatureRaw.setText("" + o.feePlusXErs1TemperatureRaw());
        this.tffeePlusXErs2SignalRaw.setText("" + o.feePlusXErs2SignalRaw());
        this.tffeePlusXErs2TemperatureRaw.setText("" + o.feePlusXErs2TemperatureRaw());
        this.tffeePlusXErs3SignalRaw.setText("" + o.feePlusXErs3SignalRaw());
        this.tffeePlusXErs3TemperatureRaw.setText("" + o.feePlusXErs3TemperatureRaw());
        this.tffeePlusXUvsSignalRaw.setText("" + o.feePlusXUvsSignalRaw());
        this.tffeeMinusXErs1SignalRaw.setText("" + o.feeMinusXErs1SignalRaw());
        this.tffeeMinusXErs1TemperatureRaw.setText("" + o.feeMinusXErs1TemperatureRaw());
        this.tffeeMinusXErs2SignalRaw.setText("" + o.feeMinusXErs2SignalRaw());
        this.tffeeMinusXErs2TemperatureRaw.setText("" + o.feeMinusXErs2TemperatureRaw());
        this.tffeeMinusXErs3SignalRaw.setText("" + o.feeMinusXErs3SignalRaw());
        this.tffeeMinusXErs3TemperatureRaw.setText("" + o.feeMinusXErs3TemperatureRaw());
        this.tffeeMinusXUvsSignalRaw.setText("" + o.feeMinusXUvsSignalRaw());
        this.tffeePlusYErs1SignalRaw.setText("" + o.feePlusYErs1SignalRaw());
        this.tffeePlusYErs1TemperatureRaw.setText("" + o.feePlusYErs1TemperatureRaw());
        this.tffeePlusYErs2SignalRaw.setText("" + o.feePlusYErs2SignalRaw());
        this.tffeePlusYErs2TemperatureRaw.setText("" + o.feePlusYErs2TemperatureRaw());
        this.tffeePlusYErs3SignalRaw.setText("" + o.feePlusYErs3SignalRaw());
        this.tffeePlusYErs3TemperatureRaw.setText("" + o.feePlusYErs3TemperatureRaw());
        this.tffeePlusYUvsSignalRaw.setText("" + o.feePlusYUvsSignalRaw());
        this.tffeeMinusYErs1SignalRaw.setText("" + o.feeMinusYErs1SignalRaw());
        this.tffeeMinusYErs1TemperatureRaw.setText("" + o.feeMinusYErs1TemperatureRaw());
        this.tffeeMinusYErs2SignalRaw.setText("" + o.feeMinusYErs2SignalRaw());
        this.tffeeMinusYErs2TemperatureRaw.setText("" + o.feeMinusYErs2TemperatureRaw());
        this.tffeeMinusYErs3SignalRaw.setText("" + o.feeMinusYErs3SignalRaw());
        this.tffeeMinusYErs3TemperatureRaw.setText("" + o.feeMinusYErs3TemperatureRaw());
        this.tffeeMinusYUvsSignalRaw.setText("" + o.feeMinusYUvsSignalRaw());
        this.tfteachwearAccXRaw.setText("" + o.teachwearAccXRaw());
        this.tfteachwearAccYRaw.setText("" + o.teachwearAccYRaw());
        this.tfteachwearAccZRaw.setText("" + o.teachwearAccZRaw());
        this.tfteachwearDegCRaw.setText("" + o.teachwearDegCRaw());
        this.tfteachwearGyroXRaw.setText("" + o.teachwearGyroXRaw());
        this.tfteachwearGyroYRaw.setText("" + o.teachwearGyroYRaw());
        this.tfteachwearGyroZRaw.setText("" + o.teachwearGyroZRaw());
        this.tfteachwearMagnXRaw.setText("" + o.teachwearMagnXRaw());
        this.tfteachwearMagnYRaw.setText("" + o.teachwearMagnYRaw());
        this.tfteachwearMagnZRaw.setText("" + o.teachwearMagnZRaw());
        this.tfteachwearStateRaw.setText("" + o.teachwearStateRaw());
        this.tfteachwearResetReasonRaw.setText("" + o.teachwearResetReasonRaw());
        this.tfteachwearCRCRaw.setText("" + o.teachwearCRCRaw());
        this.tfnbTmSinceFirstStartRaw.setText("" + o.nbTmSinceFirstStartRaw());
    }

    private void allocateMainboardHk(Uvsqsat.MainboardHk o) {
        this.tfmainboardHKTimeRaw.setText("" + o.mainboardHKTimeRaw());
        this.tfhkPlus5VRaw.setText("" + o.hkPlus5VRaw());
        this.tfhkMinus5VRaw.setText("" + o.hkMinus5VRaw());
        this.tfhkMinusPolarRaw.setText("" + o.hkMinusPolarRaw());
        this.tfhkTempADCRaw.setText("" + o.hkTempADCRaw());
        this.tfhkFeePlusXVrefRaw.setText("" + o.hkFeePlusXVrefRaw());
        this.tfhkFeeMinusXVrefRaw.setText("" + o.hkFeeMinusXVrefRaw());
        this.tfhkFeePlusYVrefRaw.setText("" + o.hkFeePlusYVrefRaw());
        this.tfhkFeeMinusYVrefRaw.setText("" + o.hkFeeMinusYVrefRaw());
    }

    private void allocateObcHk(Uvsqsat.ObcHk o) {
        this.tfdummyRaw.setText("" + o.dummyRaw());
        this.tfspiCommandStatusRaw.setText("" + o.spiCommandStatusRaw());
        this.tfsupervisorEnableStatusRaw.setText("" + o.supervisorEnableStatusRaw());
        this.tfsupervisorUptimeRaw.setText("" + o.supervisorUptimeRaw());
        this.tfiobcUptimeRaw.setText("" + o.iobcUptimeRaw());
        this.tfiobcResetCountRaw.setText("" + o.iobcResetCountRaw());
        this.tfiobcMeasureTemperatureRaw.setText("" + o.iobcMeasureTemperatureRaw());
        this.tfiobcMeasure3v3InRaw.setText("" + o.iobcMeasure3v3InRaw());
        this.tfiobcMeasure3v3Raw.setText("" + o.iobcMeasure3v3Raw());
        this.tfiobcMeasure2vReferenceRaw.setText("" + o.iobcMeasure2vReferenceRaw());
        this.tfiobcMeasure1v8Raw.setText("" + o.iobcMeasure1v8Raw());
        this.tfiobcMeasure1v0Raw.setText("" + o.iobcMeasure1v0Raw());
        this.tfiobcMeasureCurrent3v3Raw.setText("" + o.iobcMeasureCurrent3v3Raw());
        this.tfiobcMeasureCurrent1v8Raw.setText("" + o.iobcMeasureCurrent1v8Raw());
        this.tfiobcMeasureCurrent1v0Raw.setText("" + o.iobcMeasureCurrent1v0Raw());
        this.tfiobcMeasureVoltRtcRaw.setText("" + o.iobcMeasureVoltRtcRaw());
        this.tfiobcAdcUpdateFlagRaw.setText("" + o.iobcAdcUpdateFlagRaw());
        this.tfiobcCrc8Raw.setText("" + o.iobcCrc8Raw());
        this.tfphotodiode1Raw.setText("" + o.photodiode1Raw());
        this.tfphotodiode2Raw.setText("" + o.photodiode2Raw());
        this.tfphotodiode3Raw.setText("" + o.photodiode3Raw());
        this.tfphotodiode4Raw.setText("" + o.photodiode4Raw());
        this.tfphotodiode5Raw.setText("" + o.photodiode5Raw());
        this.tfphotodiode6Raw.setText("" + o.photodiode6Raw());
        this.tfpanelTemperature1C.setText(String.format("%.3f", o.panelTemperature1C()));
        this.tfpanelTemperature2C.setText(String.format("%.3f", o.panelTemperature2C()));
        this.tfpanelTemperature3C.setText(String.format("%.3f", o.panelTemperature3C()));
        this.tfpanelTemperature4C.setText(String.format("%.3f", o.panelTemperature4C()));
        this.tfpanelTemperature5C.setText(String.format("%.3f", o.panelTemperature5C()));
        this.tfpanelTemperature6C.setText(String.format("%.3f", o.panelTemperature6C()));
    }

    private void allocateObcStatus(Uvsqsat.ObcStatus o) {
        this.tfspiCommandStatusRaw.setText("" + o.spiCommandStatusRaw());
        this.tfsupervisorIndexOfSubsystemRaw.setText("" + o.supervisorIndexOfSubsystemRaw());
        this.tfsupervisorMajorVersionRaw.setText("" + o.supervisorMajorVersionRaw());
        this.tfsupervisorMinorVersionRaw.setText("" + o.supervisorMinorVersionRaw());
        this.tfsupervisorPatchVersionRaw.setText("" + o.supervisorPatchVersionRaw());
        this.tfsupervisorGitHeadVersionRaw.setText("" + o.supervisorGitHeadVersionRaw());
        this.tfsupervisorSerialNumberRaw.setText("" + o.supervisorSerialNumberRaw());
        this.tfcompilationInformationByte.setText(this.toStringData(o.compilationInformationByte()));
        this.tfclockSpeedRaw.setText("" + o.clockSpeedRaw());
        this.tfcodeTypeRaw.setText("" + o.codeTypeRaw());
        this.tfcrc8Raw.setText("" + o.crc8Raw());
        this.tfswMmodeRaw.setText("" + o.swMmodeRaw());
        this.tflastResetReasonRaw.setText(this.decodelastResetReason(o.lastResetReasonRaw()));
        this.tfreservedRaw.setText("" + o.reservedRaw());
        this.tfnbResetRaw.setText("" + o.nbResetRaw());
        this.tfreserved2Raw.setText("" + o.reserved2Raw());
        this.tfdeployAntennasSystemRaw.setText("" + o.deployAntennasSystemRaw());
        this.tfnbTmSinceFirstStartRaw.setText("" + o.nbTmSinceFirstStartRaw());
        this.tfnbTcSinceFirstStartRaw.setText("" + o.nbTcSinceFirstStartRaw());
        this.tfnbBadTcSinceFirstStartRaw.setText("" + o.nbBadTcSinceFirstStartRaw());
        this.tfnbTmInSdcardRaw.setText("" + o.nbTmInSdcardRaw());
        this.tfsdcardStatusRaw.setText("" + o.sdcardStatusRaw());
        this.tfsdcardLastErrorRaw.setText("" + o.sdcardLastErrorRaw());
        this.tfoldTimeTMInSdcardRaw.setText("" + o.oldTimeTMInSdcardRaw());
        this.tfnewTimeTMInSdcardRaw.setText("" + o.newTimeTMInSdcardRaw());
    }

    private void allocateTrxvurxHk(Uvsqsat.TrxvurxHk o) {
        this.tftrxvurxInstantaneousReceivedSignalDopplerHz.setText(String.format("%.3f", o.trxvurxInstantaneousReceivedSignalDopplerHz()));
        this.tftrxvurxInstantaneousReceivedSignalStrengthDbm.setText(String.format("%.3f", o.trxvurxInstantaneousReceivedSignalStrengthDbm()));
        this.tftrxvurxSupplyVoltageV.setText(String.format("%.3f", o.trxvurxSupplyVoltageV()));
        this.tftrxvurxTotalSupplyCurrentMa.setText(String.format("%.3f", o.trxvurxTotalSupplyCurrentMa()));
        this.tftrxvurxTransmitterCurrentMa.setText(String.format("%.3f", o.trxvurxTransmitterCurrentMa()));
        this.tftrxvurxReceiverCurrentMa.setText(String.format("%.3f", o.trxvurxReceiverCurrentMa()));
        this.tftrxvurxPowerAmplifierCurrentMa.setText(String.format("%.3f", o.trxvurxPowerAmplifierCurrentMa()));
        this.tftrxvurxPowerAmplifierTemperatureC.setText(String.format("%.3f", o.trxvurxPowerAmplifierTemperatureC()));
        this.tftrxvurxLocalOscillatorTemperatureC.setText(String.format("%.3f", o.trxvurxLocalOscillatorTemperatureC()));
        this.tftrxvurxZeroPaddingRaw.setText("" + o.trxvurxZeroPaddingRaw());
        this.tftrxvuRxUptimeRaw.setText("" + o.trxvuRxUptimeRaw());
    }

    private void allocateTrxvutxHk(Uvsqsat.TrxvutxHk o) {
        this.tftrxvutxInstantaneousRfReflectedPowerFromTransmitterPortMw.setText(String.format("%.3f", o.trxvutxInstantaneousRfReflectedPowerFromTransmitterPortMw()));
        this.tftrxvutxInstantaneousRfForwardPowerFromTransmitterPortMw.setText(String.format("%.3f", o.trxvutxInstantaneousRfForwardPowerFromTransmitterPortMw()));
        this.tftrxvutxSupplyVoltageV.setText(String.format("%.3f", o.trxvutxSupplyVoltageV()));
        this.tftrxvutxTotalSupplyCurrentMa.setText(String.format("%.3f", o.trxvutxTotalSupplyCurrentMa()));
        this.tftrxvutxTransmitterCurrentMa.setText(String.format("%.3f", o.trxvutxTransmitterCurrentMa()));
        this.tftrxvutxReceiverCurrentMa.setText(String.format("%.3f", o.trxvutxReceiverCurrentMa()));
        this.tftrxvutxPowerAmplifierCurrentMa.setText(String.format("%.3f", o.trxvutxPowerAmplifierCurrentMa()));
        this.tftrxvutxPowerAmplifierTemperatureC.setText(String.format("%.3f", o.trxvutxPowerAmplifierTemperatureC()));
        this.tftrxvutxLocalOscillatorTemperatureC.setText(String.format("%.3f", o.trxvutxLocalOscillatorTemperatureC()));
        this.tftrxvutxZeroPaddingRaw.setText("" + o.trxvutxZeroPaddingRaw());
        this.tftrxvuTxUptimeRaw.setText("" + o.trxvuTxUptimeRaw());
        this.tftrxvuTxStateRaw.setText("" + o.trxvuTxStateRaw());
    }

    public String decodeSwMode(int mode) {
        String value = "Unknow";
        switch (mode) {
            case 0: {
                value = "INIT";
                break;
            }
            case 1: {
                value = "DETUMBLING";
                break;
            }
            case 2: {
                value = "STANDBY";
                break;
            }
            case 3: {
                value = "OPERATIONAL";
                break;
            }
            case 4: {
                value = "SAFE";
                break;
            }
            case 5: {
                value = "TRANSPONDER";
            }
        }
        return value;
    }

    public String decodelastResetReason(int lastResetReason) {
        String value = "Unknow";
        switch (lastResetReason) {
            case 0: {
                value = "First start";
                break;
            }
            case 128: {
                value = "TC Init";
                break;
            }
            case 129: {
                value = "No TC since 4 days";
            }
        }
        return value;
    }

    public String decodeResetOrder(int resetOrder) {
        String value = "Unknow";
        switch (resetOrder) {
            case 0: {
                value = "No Order";
                break;
            }
            case 202: {
                value = "TC Order";
            }
        }
        return value;
    }

    private String toStringData(byte[] bytes) {
        StringBuffer buffer = new StringBuffer();
        for (byte b : bytes) {
            buffer.append(String.format("%02X ", b));
        }
        return buffer.toString();
    }
}

