/*
 * Decompiled with CFR 0.152.
 */
package org.josast.config.databinding;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.logging.Logger;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;

public abstract class AbstractDataBinding
implements Serializable {
    private static final long serialVersionUID = 8410353753997330889L;
    private transient String folder = ".\\";
    private Logger log = Logger.getLogger("AmsatLogger");

    public Object load() {
        String fileName = this.folder + "\\" + this.getClass().getName() + ".xml";
        Object o = null;
        FileReader reader = null;
        File f = new File(fileName);
        if (f.exists()) {
            try {
                reader = new FileReader(fileName);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            try {
                o = Unmarshaller.unmarshal(this.getClass(), reader);
            }
            catch (MarshalException e) {
                e.printStackTrace();
            }
            catch (ValidationException e1) {
                e1.printStackTrace();
            }
            try {
                ((Reader)reader).close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            this.log.warning("file not found");
        }
        return o;
    }

    public void save() {
        String fileName = this.folder + "\\" + this.getClass().getName() + ".xml";
        File file = new File(fileName);
        FileWriter writer = null;
        try {
            writer = new FileWriter(file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            Marshaller.marshal((Object)this, writer);
        }
        catch (MarshalException | ValidationException e) {
            e.printStackTrace();
        }
        try {
            ((Writer)writer).close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.log.info("file : " + file.getAbsoluteFile());
    }

    public boolean isExist() {
        String FileName = this.folder + "\\" + this.getClass().getName() + ".xml";
        File f = new File(FileName);
        return f.exists();
    }

    public String getFolder() {
        return this.folder;
    }

    public boolean setFolder(String folder) {
        this.folder = folder;
        File f = new File(folder);
        boolean value = true;
        if (!f.exists()) {
            value = f.mkdir();
        }
        return value;
    }
}

