/*
 * Decompiled with CFR 0.152.
 */
package org.josast.SIDS.app;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.josast.SIDS.SIDSData;
import org.josast.SIDS.Station;

public class SendFile {
    private SIDSData sids = new SIDSData();
    private BufferedReader lecteurAvecBuffer = null;
    private String ligne;

    public void initSIDS() {
        this.sids.setStation(new Station());
        this.sids.setNoradID(99990);
    }

    public void openFile(String file) {
        try {
            this.lecteurAvecBuffer = new BufferedReader(new FileReader(file));
        }
        catch (FileNotFoundException exc) {
            System.out.println("Erreur d'ouverture");
        }
    }

    public void readFile() {
        boolean first = false;
        Date dateref = null;
        try {
            while ((this.ligne = this.lecteurAvecBuffer.readLine()) != null) {
                String[] result1 = this.ligne.split("=");
                String[] date = result1[1].split("]");
                String[] trame = result1[2].split("]");
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("E MMM dd hh:mm:ss z yyyy", Locale.ENGLISH);
                System.out.println("date : " + date[0] + " - Trame " + trame[0]);
                Date date2 = simpleDateFormat.parse(date[0]);
                if (!first) {
                    dateref = date2;
                    first = true;
                    continue;
                }
                System.out.println((date2.getTime() - dateref.getTime()) / 1000L);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
    }

    public void closeFile() {
        try {
            this.lecteurAvecBuffer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] argv) throws IOException {
        SendFile sf = new SendFile();
        sf.openFile(argv[0]);
        sf.initSIDS();
        sf.readFile();
        sf.closeFile();
    }
}

