/*
 * Decompiled with CFR 0.152.
 */
package org.josast.UVSQsatDecoder;

import org.josast.property.CONFIG;

public class Configuration {
    private String callsign = "Anonymous";
    private String longitude = "0.0W";
    private String latitude = "0.0N";
    private String soundModemIP = "127.0.0.1";
    private String soundModemPort = "8100";
    private String SIDSAMSATSource = "Anonymous";
    private String SIDSAMSATUrl = "https://amsat.electrolab.fr/api/V2/SIDS";
    private String SIDSSatnogsSource = "Anonymous";
    private String SIDSSatnogsURL = "https://db.satnogs.org/api/telemetry/";
    private String SIDSSatnogs = "0";
    private String SIDSAMSAT = "1";
    private int Norad = 99760;
    private boolean SISD_SatNogs = false;
    private boolean SIDS_AMSAT = true;
    private CONFIG conf = CONFIG.getInstance();

    public static Configuration getInstance() {
        return SingletonHolder.instance;
    }

    public boolean isSISD_SatNogs() {
        return this.SISD_SatNogs;
    }

    private Configuration() {
        if (this.conf.GetProperty("Callsign") != null) {
            this.callsign = this.conf.GetProperty("Callsign");
            this.latitude = this.conf.GetProperty("Latitude");
            this.longitude = this.conf.GetProperty("Longitude");
            this.SIDSAMSATSource = this.conf.GetProperty("SIDSAMSATSource");
            this.SIDSAMSATUrl = this.conf.GetProperty("SIDSAMSATUrl");
            this.SIDSSatnogsSource = this.conf.GetProperty("SIDSSatnogsSource");
            this.SIDSSatnogsURL = this.conf.GetProperty("SIDSSatnogsURL");
            this.SIDSSatnogs = this.conf.GetProperty("SIDSSatnogs");
            this.SIDSAMSAT = this.conf.GetProperty("SIDSAMSAT");
            this.soundModemIP = this.conf.GetProperty("soundModemIP");
            this.soundModemPort = this.conf.GetProperty("soundModemPort");
            this.Norad = Integer.parseUnsignedInt(this.conf.GetProperty("NoradID").trim());
            this.SISD_SatNogs = this.SIDSSatnogs.contentEquals("1");
            this.SIDS_AMSAT = this.SIDSAMSAT.contentEquals("1");
        } else {
            this.save();
        }
    }

    public void setSIDSSatnogs(String sIDSSatnogs) {
        this.SIDSSatnogs = sIDSSatnogs;
        this.SISD_SatNogs = this.SIDSSatnogs.contentEquals("1");
    }

    public void setSIDSAMSAT(String sIDSEntrySat) {
        this.SIDSAMSAT = sIDSEntrySat;
        this.SIDS_AMSAT = this.SIDSAMSAT.contentEquals("1");
    }

    public void save() {
        this.conf.SetProperty("Callsign", this.callsign);
        this.conf.SetProperty("Latitude", this.latitude);
        this.conf.SetProperty("Longitude", this.longitude);
        this.conf.SetProperty("SIDSAMSATSource", this.SIDSAMSATSource);
        this.conf.SetProperty("SIDSAMSATUrl", this.SIDSAMSATUrl);
        this.conf.SetProperty("SIDSSatnogsSource", this.SIDSSatnogsSource);
        this.conf.SetProperty("SIDSSatnogsURL", this.SIDSSatnogsURL);
        this.conf.SetProperty("SIDSSatnogs", this.SIDSSatnogs);
        this.conf.SetProperty("SIDSAMSAT", this.SIDSAMSAT);
        this.conf.SetProperty("soundModemPort", this.soundModemPort);
        this.conf.SetProperty("soundModemIP", this.soundModemIP);
        this.conf.SetProperty("NoradID", "" + this.Norad);
    }

    public String getCallsign() {
        return this.callsign;
    }

    public void setCallsign(String callsign2) {
        this.callsign = callsign2;
    }

    public String getLongitude() {
        return this.longitude;
    }

    public void setLongitude(String longitude) {
        this.longitude = longitude;
    }

    public String getLatitude() {
        return this.latitude;
    }

    public void setLatitude(String latitude) {
        this.latitude = latitude;
    }

    public String getSoundModemIP() {
        return this.soundModemIP;
    }

    public void setSoundModemIP(String soundModemIP) {
        this.soundModemIP = soundModemIP;
    }

    public String getSoundModemPort() {
        return this.soundModemPort;
    }

    public void setSoundModemPort(String soundModemPort) {
        this.soundModemPort = soundModemPort;
    }

    public String getSIDSAMSATSource() {
        return this.SIDSAMSATSource;
    }

    public void setSIDSAMSATSource(String sIDSAMSATSource) {
        this.SIDSAMSATSource = sIDSAMSATSource;
    }

    public String getSIDSAMSATUrl() {
        return this.SIDSAMSATUrl;
    }

    public void setSIDSAMSATUrl(String sIDSAMSATUrl) {
        this.SIDSAMSATUrl = sIDSAMSATUrl;
    }

    public String getSIDSSatnogsSource() {
        return this.SIDSSatnogsSource;
    }

    public void setSIDSSatnogsSource(String sIDSSatnogsSource) {
        this.SIDSSatnogsSource = sIDSSatnogsSource;
    }

    public String getSIDSSatnogsURL() {
        return this.SIDSSatnogsURL;
    }

    public void setSIDSSatnogsURL(String sIDSSatnogsURL) {
        this.SIDSSatnogsURL = sIDSSatnogsURL;
    }

    public int getNorad() {
        return this.Norad;
    }

    public void setNorad(int norad) {
        this.Norad = norad;
    }

    public boolean isSIDS_AMSAT() {
        return this.SIDS_AMSAT;
    }

    public CONFIG getConf() {
        return this.conf;
    }

    public void setConf(CONFIG conf) {
        this.conf = conf;
    }

    public void setSISD_SatNogs(boolean sISD_SatNogs) {
        this.SISD_SatNogs = sISD_SatNogs;
    }

    private static class SingletonHolder {
        private static final Configuration instance = new Configuration();

        private SingletonHolder() {
        }
    }
}

