/*
 * Decompiled with CFR 0.152.
 */
package org.josast.SIDS;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.josast.SIDS.Station;

public class SIDSData {
    private final SimpleDateFormat ISO8601DATEFORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
    private int noradID;
    private String source = "";
    private String timestamp;
    private String frame;
    private final String locator = "longLat";
    private String longitude = null;
    private String latitude = null;
    private int tncPort = 0;
    private double azimuth = 0.0;
    private double elevation = 0.0;
    private long fDown = 0L;
    private final String version = "2.0.1";

    public void setTelemetryData(Date date, String inputframe) {
        this.ISO8601DATEFORMAT.setTimeZone(TimeZone.getTimeZone("UTC"));
        this.timestamp = this.ISO8601DATEFORMAT.format(date);
        this.frame = inputframe;
    }

    public String getLongitude() {
        return this.longitude;
    }

    public void setLongitude(String longitude) {
        this.longitude = longitude;
    }

    public String getLatitude() {
        return this.latitude;
    }

    public void setLatitude(String latitudein) {
        this.latitude = latitudein;
    }

    public int getNoradID() {
        return this.noradID;
    }

    public void setNoradID(int noradID) {
        this.noradID = noradID;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public String getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(String timestamp) {
        this.timestamp = timestamp;
    }

    public String getFrame() {
        return this.frame;
    }

    public void setFrame(String frame) {
        this.frame = frame;
    }

    public int getTncPort() {
        return this.tncPort;
    }

    public void setTncPort(int tncPort) {
        this.tncPort = tncPort;
    }

    public double getAzimuth() {
        return this.azimuth;
    }

    public void setAzimuth(double azimuth) {
        this.azimuth = azimuth;
    }

    public double getElevation() {
        return this.elevation;
    }

    public void setElevation(double elevation) {
        this.elevation = elevation;
    }

    public long getfDown() {
        return this.fDown;
    }

    public void setfDown(long fDown) {
        this.fDown = fDown;
    }

    public void setStation(Station station) {
        this.source = station.getCallsign();
        this.longitude = station.getLongitude();
        this.latitude = station.getLatitude();
    }

    public String getLocator() {
        return "longLat";
    }

    public String toStringBasic() {
        StringBuilder sb = new StringBuilder();
        sb.append("noradID=");
        sb.append(this.noradID);
        sb.append("&source=");
        sb.append(this.source);
        sb.append("&timestamp=");
        sb.append(this.timestamp);
        sb.append("&frame=");
        sb.append(this.frame);
        sb.append("&locator=");
        sb.append("longLat");
        sb.append("&longitude=");
        sb.append(this.longitude);
        sb.append("&latitude=");
        sb.append(this.latitude);
        sb.append("&version=");
        sb.append("2.0.1");
        return sb.toString();
    }
}

