/*
 * Decompiled with CFR 0.152.
 */
package name.valery1707.kaitai;

import java.io.OutputStream;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.regex.Pattern;
import org.apache.commons.io.output.WriterOutputStream;
import org.slf4j.Logger;

public class LogWriter
extends Writer {
    private final Logger log;
    private final Mode mode;
    private static final Pattern NEW_LINE = Pattern.compile("[\\n\\r]");

    private LogWriter(Logger log, Mode mode) {
        this.log = log;
        this.mode = mode;
    }

    public static OutputStream log(Logger log, Mode mode) {
        return new WriterOutputStream((Writer)new LogWriter(log, mode), StandardCharsets.UTF_8, 1024, true);
    }

    public static OutputStream logInfo(Logger log) {
        return LogWriter.log(log, Mode.INFO);
    }

    public static OutputStream logError(Logger log) {
        return LogWriter.log(log, Mode.ERROR);
    }

    @Override
    public void write(char[] cbuf, int off, int len) {
        String lines = new String(cbuf, off, len).trim();
        for (String line : NEW_LINE.split(lines)) {
            this.logImpl(line.trim());
        }
    }

    private void logImpl(String line) {
        if (line.isEmpty()) {
            return;
        }
        switch (this.mode) {
            case INFO: {
                this.log.info(line);
                break;
            }
            default: {
                this.log.error(line);
            }
        }
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() {
    }

    public static enum Mode {
        INFO,
        ERROR;

    }
}

